/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.ex.ElementNotFound;
import com.codeborne.selenide.ex.ListSizeMismatch;
import com.codeborne.selenide.ex.TextsMismatch;
import com.codeborne.selenide.impl.WebElementsCollection;
import com.google.common.base.Predicate;
import java.util.Arrays;
import java.util.List;
import org.openqa.selenium.WebElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CollectionCondition
implements Predicate<List<WebElement>> {
    public static CollectionCondition empty = CollectionCondition.size(0);

    public abstract void fail(WebElementsCollection var1, List<WebElement> var2, long var3);

    public static CollectionCondition size(final int expectedSize) {
        return new CollectionCondition(){

            public boolean apply(List<WebElement> elements) {
                return elements.size() == expectedSize;
            }

            @Override
            public void fail(WebElementsCollection collection, List<WebElement> elements, long timeoutMs) {
                throw new ListSizeMismatch(expectedSize, collection, elements, timeoutMs);
            }
        };
    }

    public static CollectionCondition texts(final String ... expectedTexts) {
        return new CollectionCondition(){
            {
                if (expectedTexts.length == 0) {
                    throw new IllegalArgumentException("Array of expected texts is empty");
                }
            }

            public boolean apply(List<WebElement> elements) {
                Object[] actualTexts = ElementsCollection.getTexts(elements);
                return Arrays.equals(expectedTexts, actualTexts);
            }

            @Override
            public void fail(WebElementsCollection collection, List<WebElement> elements, long timeoutMs) {
                if (elements.isEmpty()) {
                    throw new ElementNotFound(collection, expectedTexts, timeoutMs);
                }
                throw new TextsMismatch(collection, ElementsCollection.getTexts(elements), expectedTexts, timeoutMs);
            }
        };
    }
}

