/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.impl.Describe;
import com.google.common.base.Predicate;
import java.util.regex.Pattern;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Condition
implements Predicate<WebElement> {
    public static final Condition visible = new Condition("visible", false){

        public boolean apply(WebElement element) {
            return element.isDisplayed();
        }

        public String actualValue(WebElement element) {
            return element.isDisplayed() ? "visible" : "hidden";
        }
    };
    public static final Condition present;
    public static final Condition exist;
    public static final Condition notPresent;
    public static final Condition hidden;
    public static final Condition appear;
    public static final Condition appears;
    public static final Condition disappears;
    public static final Condition disappear;
    public static final Condition readonly;
    public static final Condition empty;
    public static final Condition options;
    public static final Condition focused;
    public static final Condition enabled;
    public static final Condition disabled;
    public static final Condition selected;
    private final String name;
    private final boolean nullIsAllowed;

    public static Condition not(final Condition condition) {
        return new Condition("not(" + condition.name + ')', false){

            public boolean apply(WebElement element) {
                return !condition.apply(element);
            }

            public String actualValue(WebElement element) {
                return condition.actualValue(element);
            }
        };
    }

    public static Condition hasAttribute(String attributeName, String attributeValue) {
        return Condition.attribute(attributeName, attributeValue);
    }

    public static Condition attribute(final String attributeName) {
        return new Condition("hasAttribute", false){

            public boolean apply(WebElement element) {
                return element.getAttribute(attributeName) != null;
            }

            public String actualValue(WebElement element) {
                return element.getAttribute(attributeName);
            }

            public String toString() {
                return "got attribute " + attributeName;
            }
        };
    }

    public static Condition attribute(final String attributeName, final String expectedAttributeValue) {
        return new Condition("hasAttribute", false){

            public boolean apply(WebElement element) {
                return expectedAttributeValue.equals(Condition.getAttributeValue(element, attributeName));
            }

            public String actualValue(WebElement element) {
                return element.getAttribute(attributeName);
            }

            public String toString() {
                return "got attribute " + attributeName + '=' + expectedAttributeValue;
            }
        };
    }

    private static String getAttributeValue(WebElement element, String attributeName) {
        String attr = element.getAttribute(attributeName);
        return attr == null ? "" : attr.trim();
    }

    public static Condition value(String value) {
        return Condition.hasAttribute("value", value);
    }

    public static Condition hasValue(String value) {
        return Condition.value(value);
    }

    public static Condition name(String name) {
        return Condition.hasAttribute("name", name);
    }

    public static Condition type(String type) {
        return Condition.hasAttribute("type", type);
    }

    public static Condition id(String id) {
        return Condition.hasAttribute("id", id);
    }

    public static Condition matchesText(String text) {
        return Condition.matchText(text);
    }

    public static Condition matchText(final String regex) {
        return new Condition("match", false){

            public boolean apply(WebElement element) {
                return Condition.matches(element.getText(), regex);
            }

            public String actualValue(WebElement element) {
                return element.getText();
            }

            public String toString() {
                return "matched text '" + regex + '\'';
            }
        };
    }

    private static boolean matches(String text, String regex) {
        return Pattern.compile(".*" + regex + ".*", 32).matcher(text).matches();
    }

    public static Condition hasText(String text) {
        return Condition.text(text);
    }

    public static Condition text(final String text) {
        return new Condition("text", false){

            public boolean apply(WebElement element) {
                return element.getText().toLowerCase().contains(text.toLowerCase());
            }

            public String actualValue(WebElement element) {
                return element.getText();
            }

            public String toString() {
                return "got text '" + text + '\'';
            }
        };
    }

    public static Condition textCaseSensitive(final String text) {
        return new Condition("textCaseSensitive", false){

            public boolean apply(WebElement element) {
                return element.getText().contains(text);
            }

            public String actualValue(WebElement element) {
                return element.getText();
            }

            public String toString() {
                return "got text '" + text + '\'';
            }
        };
    }

    public static Condition exactText(final String text) {
        return new Condition("exactText", false){

            public boolean apply(WebElement element) {
                return text.equalsIgnoreCase(element.getText());
            }

            public String actualValue(WebElement element) {
                return element.getText();
            }

            public String toString() {
                return "got exactly the text '" + text + '\'';
            }
        };
    }

    public static Condition exactTextCaseSensitive(final String text) {
        return new Condition("exactTextCaseSensitive", false){

            public boolean apply(WebElement element) {
                return text.equals(element.getText());
            }

            public String actualValue(WebElement element) {
                return element.getText();
            }

            public String toString() {
                return "got exactly the text '" + text + '\'';
            }
        };
    }

    public static Condition hasOptions() {
        return options;
    }

    public static boolean hasClass(WebElement element, String cssClass) {
        String classes = element.getAttribute("class");
        return classes != null && Condition.contains(classes.split(" "), cssClass);
    }

    private static <T> boolean contains(T[] objects, T object) {
        for (T object1 : objects) {
            if (!object.equals(object1)) continue;
            return true;
        }
        return false;
    }

    public static Condition cssClass(String cssClass) {
        return Condition.hasClass(cssClass);
    }

    public static Condition hasClass(final String cssClass) {
        return new Condition("hasClass", false){

            public boolean apply(WebElement element) {
                return 15.hasClass(element, cssClass);
            }

            public String actualValue(WebElement element) {
                return "class=" + element.getAttribute("class");
            }

            public String toString() {
                return "got class '" + cssClass + '\'';
            }
        };
    }

    public static Condition hasNotClass(final String cssClass) {
        return new Condition("hasNotClass", false){

            public boolean apply(WebElement element) {
                return !16.hasClass(element, cssClass);
            }

            public String actualValue(WebElement element) {
                return "class=" + element.getAttribute("class");
            }

            public String toString() {
                return "lose class '" + cssClass + '\'';
            }
        };
    }

    protected Condition(String name, boolean nullIsAllowed) {
        this.name = name;
        this.nullIsAllowed = nullIsAllowed;
    }

    public abstract boolean apply(WebElement var1);

    public final boolean applyNull() {
        return this.nullIsAllowed;
    }

    public abstract String actualValue(WebElement var1);

    public String toString() {
        return this.name;
    }

    static {
        exist = present = new Condition("present", false){

            public boolean apply(WebElement element) {
                return true;
            }

            public String actualValue(WebElement element) {
                return "exists";
            }
        };
        notPresent = new Condition("notPresent", true){

            public boolean apply(WebElement element) {
                return false;
            }

            public String actualValue(WebElement element) {
                return "exists";
            }
        };
        hidden = new Condition("hidden", true){

            public boolean apply(WebElement element) {
                try {
                    return !element.isDisplayed();
                }
                catch (StaleElementReferenceException elementHasDisappeared) {
                    return true;
                }
            }

            public String actualValue(WebElement element) {
                return element.isDisplayed() ? "visible" : "hidden";
            }
        };
        appear = visible;
        appears = visible;
        disappears = hidden;
        disappear = hidden;
        readonly = Condition.attribute("readonly");
        empty = new Condition("empty", false){
            private final Condition emptyValue = 8.value("");
            private final Condition emptyText = 8.exactText("");

            public boolean apply(WebElement element) {
                return this.emptyValue.apply(element) && this.emptyText.apply(element);
            }

            public String actualValue(WebElement element) {
                return "value=" + Condition.getAttributeValue(element, "value") + ", text='" + element.getText() + '\'';
            }
        };
        options = new Condition("hasOptions", false){

            public boolean apply(WebElement element) {
                try {
                    return element.getText().length() > 0;
                }
                catch (NoSuchElementException e) {
                    return false;
                }
            }

            public String actualValue(WebElement element) {
                return element.getText();
            }

            public String toString() {
                return "got any options";
            }
        };
        focused = new Condition("focused", false){

            public boolean apply(WebElement webElement) {
                WebElement focusedElement = Selenide.getFocusedElement();
                return focusedElement != null && focusedElement.equals(webElement);
            }

            public String actualValue(WebElement webElement) {
                WebElement focusedElement = Selenide.getFocusedElement();
                return focusedElement == null ? "No focused focusedElement found " : "Focused focusedElement: " + Describe.describe(focusedElement) + ", current focusedElement: " + Describe.describe(webElement);
            }
        };
        enabled = new Condition("enabled", false){

            public boolean apply(WebElement element) {
                return element.isEnabled();
            }

            public String actualValue(WebElement element) {
                return element.isEnabled() ? "enabled" : "disabled";
            }
        };
        disabled = new Condition("disabled", false){

            public boolean apply(WebElement element) {
                return !element.isEnabled();
            }

            public String actualValue(WebElement element) {
                return element.isEnabled() ? "enabled" : "disabled";
            }
        };
        selected = new Condition("selected", false){

            public boolean apply(WebElement element) {
                return element.isSelected();
            }

            public String actualValue(WebElement element) {
                return String.valueOf(element.isSelected());
            }
        };
    }
}

