/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import org.openqa.selenium.By;

public class Selectors {
    public static By withText(String elementText) {
        Selectors.assertDoesNotContainBothApostrophesAndQuotes(elementText);
        return elementText.contains("'") ? By.xpath((String)(".//*/text()[contains(normalize-space(.), \"" + elementText + "\")]/parent::*")) : By.xpath((String)(".//*/text()[contains(normalize-space(.), '" + elementText + "')]/parent::*"));
    }

    public static By byText(String elementText) {
        Selectors.assertDoesNotContainBothApostrophesAndQuotes(elementText);
        return elementText.contains("'") ? By.xpath((String)(".//*/text()[normalize-space(.) = \"" + elementText + "\"]/parent::*")) : By.xpath((String)(".//*/text()[normalize-space(.) = '" + elementText + "']/parent::*"));
    }

    public static By byAttribute(String attributeName, String attributeValue) {
        Selectors.assertDoesNotContainBothApostrophesAndQuotes(attributeValue);
        return attributeValue.contains("'") ? By.xpath((String)(".//*[@" + attributeName + " = \"" + attributeValue + "\"]")) : By.xpath((String)(".//*[@" + attributeName + " = '" + attributeValue + "']"));
    }

    public static By by(String attributeName, String attributeValue) {
        return Selectors.byAttribute(attributeName, attributeValue);
    }

    public static By byTitle(String title) {
        return Selectors.byAttribute("title", title);
    }

    private static void assertDoesNotContainBothApostrophesAndQuotes(String elementText) {
        if (elementText.contains("'") && elementText.contains("\"")) {
            throw new UnsupportedOperationException("Text with both apostrophes and quotes is not supported");
        }
    }

    public static By byValue(String value) {
        return Selectors.byAttribute("value", value);
    }
}

