/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.WebDriverProvider;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.internal.Killable;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.remote.Augmenter;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;

public class WebDriverRunner {
    public static final String CHROME = "chrome";
    public static final String INTERNET_EXPLORER = "ie";
    public static final String FIREFOX = "firefox";
    public static final String HTMLUNIT = "htmlunit";
    public static final String PHANTOMJS = "phantomjs";
    public static final String OPERA = "opera";
    private static WebDriver webdriver;

    public static void setWebDriver(WebDriver webDriver) {
        webdriver = webDriver;
    }

    public static WebDriver getWebDriver() {
        if (webdriver == null) {
            webdriver = WebDriverRunner.createDriver();
        }
        return webdriver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeWebDriver() {
        if (webdriver != null) {
            if (!Configuration.holdBrowserOpen) {
                try {
                    webdriver.quit();
                }
                catch (WebDriverException cannotCloseBrowser) {
                    System.err.println("Cannot close browser normally: " + WebDriverRunner.cleanupWebDriverExceptionMessage(cannotCloseBrowser));
                }
                finally {
                    WebDriverRunner.killBrowser();
                }
            }
            webdriver = null;
        }
    }

    static void killBrowser() {
        if (webdriver instanceof Killable) {
            try {
                ((Killable)webdriver).kill();
            }
            catch (Exception e) {
                System.err.println("Failed to kill browser " + webdriver + ':');
                e.printStackTrace();
            }
        }
    }

    public static boolean ie() {
        return INTERNET_EXPLORER.equalsIgnoreCase(Configuration.browser);
    }

    public static boolean htmlUnit() {
        return Configuration.browser != null && Configuration.browser.startsWith(HTMLUNIT);
    }

    public static boolean phantomjs() {
        return PHANTOMJS.equalsIgnoreCase(Configuration.browser);
    }

    public static void clearBrowserCache() {
        if (webdriver != null) {
            webdriver.manage().deleteAllCookies();
        }
    }

    public static String source() {
        return WebDriverRunner.getWebDriver().getPageSource();
    }

    public static String url() {
        return WebDriverRunner.getWebDriver().getCurrentUrl();
    }

    public static String takeScreenShot(String className, String methodName) {
        return WebDriverRunner.takeScreenShot(WebDriverRunner.getScreenshotFileName(className, methodName));
    }

    static String getScreenshotFileName(String className, String methodName) {
        return className.replace('.', File.separatorChar) + File.separatorChar + methodName;
    }

    public static String takeScreenShot(String fileName) {
        if (webdriver == null) {
            System.err.println("Cannot take screenshot because browser is not started");
            return null;
        }
        File targetFile = new File(Configuration.reportsFolder, fileName + ".html");
        try {
            WebDriverRunner.writeToFile(webdriver.getPageSource(), targetFile);
        }
        catch (Exception e) {
            System.err.println(e);
        }
        if (webdriver instanceof TakesScreenshot) {
            targetFile = WebDriverRunner.takeScreenshotImage((TakesScreenshot)webdriver, fileName, targetFile);
        } else if (webdriver instanceof RemoteWebDriver) {
            WebDriver remoteDriver = new Augmenter().augment(webdriver);
            if (webdriver instanceof TakesScreenshot) {
                targetFile = WebDriverRunner.takeScreenshotImage((TakesScreenshot)remoteDriver, fileName, targetFile);
            }
        }
        return targetFile.getAbsolutePath();
    }

    private static File takeScreenshotImage(TakesScreenshot driver, String fileName, File targetFile) {
        try {
            File scrFile = (File)driver.getScreenshotAs(OutputType.FILE);
            File imageFile = new File(Configuration.reportsFolder, fileName + ".png");
            WebDriverRunner.copyFile(scrFile, imageFile);
            return imageFile;
        }
        catch (Exception e) {
            System.err.println(e);
            return targetFile;
        }
    }

    private static void copyFile(File sourceFile, File targetFile) throws IOException {
        WebDriverRunner.copyFile(new FileInputStream(sourceFile), targetFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(InputStream in, File targetFile) throws IOException {
        WebDriverRunner.ensureFolderExists(targetFile);
        byte[] buffer = new byte[1024];
        try {
            FileOutputStream out = new FileOutputStream(targetFile);
            try {
                int len;
                while ((len = in.read(buffer)) != -1) {
                    out.write(buffer, 0, len);
                }
            }
            finally {
                out.close();
            }
        }
        finally {
            in.close();
        }
    }

    private static void writeToFile(String content, File targetFile) throws IOException {
        WebDriverRunner.copyFile(new ByteArrayInputStream(content.getBytes()), targetFile);
    }

    private static File ensureFolderExists(File targetFile) {
        File folder = targetFile.getParentFile();
        if (!folder.exists()) {
            System.err.println("Creating folder: " + folder);
            if (!folder.mkdirs()) {
                System.err.println("Failed to create " + folder);
            }
        }
        return targetFile;
    }

    private static WebDriver createDriver() {
        if (Configuration.remote != null) {
            return WebDriverRunner.createRemoteDriver(Configuration.remote, Configuration.browser);
        }
        if (CHROME.equalsIgnoreCase(Configuration.browser)) {
            ChromeOptions options = new ChromeOptions();
            if (Configuration.startMaximized) {
                options.addArguments(new String[]{"chrome.switches", "--start-maximized"});
            }
            return new ChromeDriver(options);
        }
        if (WebDriverRunner.ie()) {
            return WebDriverRunner.maximize((RemoteWebDriver)new InternetExplorerDriver());
        }
        if (WebDriverRunner.htmlUnit()) {
            DesiredCapabilities capabilities = DesiredCapabilities.htmlUnit();
            capabilities.setCapability("The xpath expression '%s' selected an object of type '%s' instead of a WebElement", true);
            capabilities.setCapability("The xpath expression '%s' cannot be evaluated", false);
            capabilities.setJavascriptEnabled(true);
            if (Configuration.browser.indexOf(58) > -1) {
                String emulatedBrowser = Configuration.browser.replaceFirst("htmlunit:(.*)", "$1");
                capabilities.setVersion(emulatedBrowser);
            }
            return new HtmlUnitDriver((Capabilities)capabilities);
        }
        if (FIREFOX.equalsIgnoreCase(Configuration.browser)) {
            return WebDriverRunner.maximize((RemoteWebDriver)new FirefoxDriver());
        }
        if (OPERA.equalsIgnoreCase(Configuration.browser)) {
            return WebDriverRunner.createInstanceOf("com.opera.core.systems.OperaDriver");
        }
        if (PHANTOMJS.equals(Configuration.browser)) {
            DesiredCapabilities capabilities = new DesiredCapabilities();
            capabilities.setJavascriptEnabled(true);
            capabilities.setCapability("takesScreenshot", true);
            return new PhantomJSDriver((Capabilities)capabilities);
        }
        return WebDriverRunner.createInstanceOf(Configuration.browser);
    }

    private static RemoteWebDriver maximize(RemoteWebDriver driver) {
        if (Configuration.startMaximized) {
            driver.manage().window().maximize();
        }
        return driver;
    }

    private static WebDriver createInstanceOf(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            if (WebDriverProvider.class.isAssignableFrom(clazz)) {
                return ((WebDriverProvider)clazz.newInstance()).createDriver();
            }
            return (WebDriver)Class.forName(className).newInstance();
        }
        catch (Exception invalidClassName) {
            throw new IllegalArgumentException(invalidClassName);
        }
    }

    private static WebDriver createRemoteDriver(String remote, String browser) {
        try {
            DesiredCapabilities capabilities = new DesiredCapabilities();
            capabilities.setBrowserName(browser);
            return new RemoteWebDriver(new URL(remote), (Capabilities)capabilities);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid 'remote' parameter: " + remote, e);
        }
    }

    public static String cleanupWebDriverExceptionMessage(WebDriverException webDriverException) {
        return WebDriverRunner.cleanupWebDriverExceptionMessage(webDriverException.toString());
    }

    static String cleanupWebDriverExceptionMessage(String webDriverExceptionInfo) {
        return webDriverExceptionInfo == null || webDriverExceptionInfo.indexOf(10) == -1 ? webDriverExceptionInfo : webDriverExceptionInfo.substring(0, webDriverExceptionInfo.indexOf(10)).replaceFirst("(.*)\\(WARNING: The server did not provide any stacktrace.*", "$1").replaceFirst("org\\.openqa\\.selenium\\.(.*)", "$1").trim();
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                WebDriverRunner.closeWebDriver();
            }
        });
    }
}

