/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.WebDriverRunner;
import java.net.URL;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriverException;

public class Navigator {
    public void open(String relativeOrAbsoluteUrl) {
        if (relativeOrAbsoluteUrl.startsWith("http:") || relativeOrAbsoluteUrl.startsWith("https:") || this.isLocalFile(relativeOrAbsoluteUrl)) {
            this.navigateToAbsoluteUrl(relativeOrAbsoluteUrl);
        } else {
            this.navigateToAbsoluteUrl(this.absoluteUrl(relativeOrAbsoluteUrl));
        }
    }

    public void open(URL url) {
        this.navigateToAbsoluteUrl(url.toExternalForm());
    }

    protected String absoluteUrl(String relativeUrl) {
        return Configuration.baseUrl + relativeUrl;
    }

    protected void navigateToAbsoluteUrl(String url) {
        if (WebDriverRunner.ie() && !this.isLocalFile(url)) {
            url = this.makeUniqueUrlToAvoidIECaching(url, System.nanoTime());
        }
        try {
            WebDriverRunner.getWebDriver().navigate().to(url);
        }
        catch (WebDriverException e) {
            e.addInfo("selenide.url", url);
            e.addInfo("selenide.baseUrl", Configuration.baseUrl);
            throw e;
        }
        this.waitUntilPageIsLoaded();
    }

    protected void waitUntilPageIsLoaded() {
        Selenide.$(By.tagName((String)"body")).should(Condition.appear);
    }

    protected String makeUniqueUrlToAvoidIECaching(String url, long unique) {
        if (url.contains("timestamp=")) {
            return url.replaceFirst("(.*)(timestamp=)(.*)([&#].*)", "$1$2" + unique + "$4").replaceFirst("(.*)(timestamp=)(.*)$", "$1$2" + unique);
        }
        return url.contains("?") ? url + "&timestamp=" + unique : url + "?timestamp=" + unique;
    }

    private boolean isLocalFile(String url) {
        return url.startsWith("file:");
    }
}

