/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.testng;

import com.codeborne.selenide.WebDriverRunner;
import org.testng.ITestResult;
import org.testng.reporters.ExitCodeListener;

public class ScreenShooter
extends ExitCodeListener {
    public static boolean captureFailingTests = true;
    public static boolean captureSuccessfulTests;

    public void onTestFailure(ITestResult result) {
        super.onTestFailure(result);
        if (captureFailingTests) {
            System.err.println("Saved failed test screenshot to: " + this.screenShot(result));
        }
    }

    public void onTestSuccess(ITestResult result) {
        super.onTestSuccess(result);
        if (captureSuccessfulTests) {
            System.out.println("Saved succeeded test screenshot to: " + this.screenShot(result));
        }
    }

    protected String screenShot(ITestResult result) {
        String className = result.getMethod().getTestClass().getName();
        String methodName = result.getMethod().getMethodName();
        return WebDriverRunner.takeScreenShot(className, methodName);
    }
}

