/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.ex.DialogTextMismatch;
import com.codeborne.selenide.impl.BySelectorCollection;
import com.codeborne.selenide.impl.Navigator;
import com.codeborne.selenide.impl.SelenideFieldDecorator;
import com.codeborne.selenide.impl.WaitingSelenideElement;
import com.codeborne.selenide.impl.WebElementProxy;
import com.codeborne.selenide.impl.WebElementsCollectionWrapper;
import java.net.URL;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.PageFactory;
import org.openqa.selenium.support.pagefactory.FieldDecorator;
import org.openqa.selenium.support.ui.FluentWait;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Selenide {
    public static Navigator navigator = new Navigator();

    public static void open(String relativeOrAbsoluteUrl) {
        navigator.open(relativeOrAbsoluteUrl);
        Selenide.mockModalDialogs();
    }

    public static void open(URL absoluteUrl) {
        navigator.open(absoluteUrl);
        Selenide.mockModalDialogs();
    }

    private static boolean doDismissModalDialogs() {
        return WebDriverRunner.isHeadless() || Configuration.dismissModalDialogs;
    }

    private static void mockModalDialogs() {
        if (Selenide.doDismissModalDialogs()) {
            String jsCode = "  window._selenide_modalDialogReturnValue = true;\n  window.alert = function(message) {};\n  window.confirm = function(message) {\n    return window._selenide_modalDialogReturnValue;\n  };";
            Selenide.executeJavaScript(jsCode);
        }
    }

    public static <PageObjectClass> PageObjectClass open(String relativeOrAbsoluteUrl, Class<PageObjectClass> pageObjectClassClass) {
        Selenide.open(relativeOrAbsoluteUrl);
        return Selenide.page(pageObjectClassClass);
    }

    public static <PageObjectClass> PageObjectClass open(URL absoluteUrl, Class<PageObjectClass> pageObjectClassClass) {
        Selenide.open(absoluteUrl);
        return Selenide.page(pageObjectClassClass);
    }

    public static void close() {
        WebDriverRunner.closeWebDriver();
    }

    public static void refresh() {
        navigator.open(WebDriverRunner.url());
    }

    public static String title() {
        return WebDriverRunner.getWebDriver().getTitle();
    }

    public static void sleep(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public static String screenshot(String fileName) {
        return WebDriverRunner.takeScreenShot(fileName);
    }

    public static SelenideElement $(WebElement webElement) {
        return WebElementProxy.wrap(webElement);
    }

    public static SelenideElement $(String cssSelector) {
        return Selenide.getElement(By.cssSelector((String)cssSelector));
    }

    public static SelenideElement $(By seleniumSelector) {
        return Selenide.getElement(seleniumSelector);
    }

    public static SelenideElement $(By seleniumSelector, int index) {
        return Selenide.getElement(seleniumSelector, index);
    }

    public static SelenideElement $(WebElement parent, String cssSelector) {
        return WaitingSelenideElement.wrap((SearchContext)Selenide.$(parent), By.cssSelector((String)cssSelector), 0);
    }

    public static SelenideElement $(String cssSelector, int index) {
        return WaitingSelenideElement.wrap(null, By.cssSelector((String)cssSelector), index);
    }

    public static SelenideElement $(WebElement parent, String cssSelector, int index) {
        return WaitingSelenideElement.wrap((SearchContext)Selenide.$(parent), By.cssSelector((String)cssSelector), index);
    }

    protected static SelenideElement $(WebElement parent, By selector, int index) {
        return WaitingSelenideElement.wrap((SearchContext)Selenide.$(parent), selector, index);
    }

    public static ElementsCollection $$(Collection<? extends WebElement> elements) {
        return new ElementsCollection(new WebElementsCollectionWrapper(elements));
    }

    public static ElementsCollection $$(String cssSelector) {
        return new ElementsCollection(new BySelectorCollection(By.cssSelector((String)cssSelector)));
    }

    public static ElementsCollection $$(By seleniumSelector) {
        return new ElementsCollection(new BySelectorCollection(seleniumSelector));
    }

    public static ElementsCollection $$(WebElement parent, String cssSelector) {
        return new ElementsCollection(new BySelectorCollection(parent, By.cssSelector((String)cssSelector)));
    }

    public static ElementsCollection $$(WebElement parent, By seleniumSelector) {
        return new ElementsCollection(new BySelectorCollection(parent, seleniumSelector));
    }

    public static SelenideElement getElement(By criteria) {
        return WaitingSelenideElement.wrap(null, criteria, 0);
    }

    public static SelenideElement getElement(By criteria, int index) {
        return WaitingSelenideElement.wrap(null, criteria, index);
    }

    public static ElementsCollection getElements(By criteria) {
        return Selenide.$$(criteria);
    }

    public static Object executeJavaScript(String jsCode) {
        return ((JavascriptExecutor)WebDriverRunner.getWebDriver()).executeScript(jsCode, new Object[0]);
    }

    public static SelenideElement selectRadio(By radioField, String value) {
        Selenide.$(radioField).shouldBe(Condition.enabled);
        for (WebElement radio : Selenide.$$(radioField)) {
            if (!value.equals(radio.getAttribute("value"))) continue;
            radio.click();
            return WebElementProxy.wrap(radio);
        }
        throw new NoSuchElementException(radioField + " and value " + value);
    }

    public static SelenideElement getSelectedRadio(By radioField) {
        for (WebElement radio : Selenide.$$(radioField)) {
            if (radio.getAttribute("checked") == null) continue;
            return WebElementProxy.wrap(radio);
        }
        return null;
    }

    public static void onConfirmReturn(boolean confirmReturnValue) {
        if (Selenide.doDismissModalDialogs()) {
            Selenide.executeJavaScript("window._selenide_modalDialogReturnValue = " + confirmReturnValue + ';');
        }
    }

    public static void confirm(String expectedDialogText) {
        if (!Selenide.doDismissModalDialogs()) {
            Alert alert = WebDriverRunner.getWebDriver().switchTo().alert();
            String actualDialogText = alert.getText();
            alert.accept();
            Selenide.checkDialogText(expectedDialogText, actualDialogText);
        }
    }

    public static void dismiss(String expectedDialogText) {
        if (!Selenide.doDismissModalDialogs()) {
            Alert alert = WebDriverRunner.getWebDriver().switchTo().alert();
            String actualDialogText = alert.getText();
            alert.dismiss();
            Selenide.checkDialogText(expectedDialogText, actualDialogText);
        }
    }

    private static void checkDialogText(String expectedDialogText, String actualDialogText) {
        if (expectedDialogText != null && !expectedDialogText.equals(actualDialogText)) {
            throw new DialogTextMismatch(actualDialogText, expectedDialogText);
        }
    }

    public static WebDriver.TargetLocator switchTo() {
        return WebDriverRunner.getWebDriver().switchTo();
    }

    public static WebElement getFocusedElement() {
        return (WebElement)Selenide.executeJavaScript("return document.activeElement");
    }

    public static <PageObjectClass> PageObjectClass page(Class<PageObjectClass> pageObjectClass) {
        try {
            return Selenide.page(pageObjectClass.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create new instance of " + pageObjectClass, e);
        }
    }

    public static <PageObjectClass, T extends PageObjectClass> PageObjectClass page(T pageObject) {
        PageFactory.initElements((FieldDecorator)new SelenideFieldDecorator((SearchContext)WebDriverRunner.getWebDriver()), pageObject);
        return pageObject;
    }

    public static FluentWait<WebDriver> Wait() {
        return new FluentWait((Object)WebDriverRunner.getWebDriver()).withTimeout(Configuration.timeout, TimeUnit.MILLISECONDS).pollingEvery(Configuration.pollingInterval, TimeUnit.MILLISECONDS);
    }

    public static Actions actions() {
        return new Actions(WebDriverRunner.getWebDriver());
    }
}

