/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.WebDriverRunner;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.WebElement;

public class FileDownloader {
    public static FileDownloader instance = new FileDownloader();

    public File download(WebElement element) throws IOException {
        String fileToDownloadLocation = element.getAttribute("href");
        if (fileToDownloadLocation.trim().isEmpty()) {
            throw new IllegalArgumentException("The element does not have href attribute");
        }
        HttpResponse response = this.executeHttpRequest(fileToDownloadLocation);
        File downloadedFile = this.prepareTargetFile(fileToDownloadLocation, response);
        return this.saveFileContent(response, downloadedFile);
    }

    protected HttpResponse executeHttpRequest(String fileToDownloadLocation) throws IOException {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpGet httpGet = new HttpGet(fileToDownloadLocation);
        BasicHttpContext localContext = new BasicHttpContext();
        localContext.setAttribute("http.cookie-store", (Object)this.mimicCookieState());
        return httpClient.execute((HttpUriRequest)httpGet, (HttpContext)localContext);
    }

    protected File prepareTargetFile(String fileToDownloadLocation, HttpResponse response) throws MalformedURLException {
        return new File(Configuration.reportsFolder, this.getFileName(fileToDownloadLocation, response));
    }

    protected String getFileName(String fileToDownloadLocation, HttpResponse response) throws MalformedURLException {
        for (Header header : response.getAllHeaders()) {
            String fileName = this.getFileNameFromContentDisposition(header.getName(), header.getValue());
            if (fileName == null) continue;
            return fileName;
        }
        System.out.println("DOWNLOAD HEADERS:");
        for (Header header : response.getAllHeaders()) {
            System.out.println(header.getName() + '=' + header.getValue());
        }
        return new URL(fileToDownloadLocation).getFile().replaceFirst("/|\\\\", "");
    }

    protected String getFileNameFromContentDisposition(String headerName, String headerValue) {
        if ("Content-Disposition".equalsIgnoreCase(headerName)) {
            Matcher regex = Pattern.compile(".*filename=\"?([^\"]*)\"?.*").matcher(headerValue);
            return regex.matches() ? regex.replaceFirst("$1") : null;
        }
        return null;
    }

    protected BasicCookieStore mimicCookieState() {
        Set seleniumCookieSet = WebDriverRunner.getWebDriver().manage().getCookies();
        BasicCookieStore mimicWebDriverCookieStore = new BasicCookieStore();
        for (Cookie seleniumCookie : seleniumCookieSet) {
            mimicWebDriverCookieStore.addCookie((org.apache.http.cookie.Cookie)this.duplicateCookie(seleniumCookie));
        }
        return mimicWebDriverCookieStore;
    }

    protected BasicClientCookie duplicateCookie(Cookie seleniumCookie) {
        BasicClientCookie duplicateCookie = new BasicClientCookie(seleniumCookie.getName(), seleniumCookie.getValue());
        duplicateCookie.setDomain(seleniumCookie.getDomain());
        duplicateCookie.setSecure(seleniumCookie.isSecure());
        duplicateCookie.setExpiryDate(seleniumCookie.getExpiry());
        duplicateCookie.setPath(seleniumCookie.getPath());
        return duplicateCookie;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File saveFileContent(HttpResponse response, File downloadedFile) throws IOException {
        try {
            FileUtils.copyInputStreamToFile((InputStream)response.getEntity().getContent(), (File)downloadedFile);
        }
        finally {
            response.getEntity().getContent().close();
        }
        return downloadedFile;
    }
}

