/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.impl.ScreenShotLaboratory;
import com.codeborne.selenide.impl.WebDriverThreadLocalContainer;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.events.WebDriverEventListener;

public class WebDriverRunner {
    public static WebDriverThreadLocalContainer webdriverContainer = new WebDriverThreadLocalContainer();
    public static ScreenShotLaboratory screenshots = new ScreenShotLaboratory();
    public static final String CHROME = "chrome";
    public static final String INTERNET_EXPLORER = "ie";
    public static final String FIREFOX = "firefox";
    public static final String HTMLUNIT = "htmlunit";
    public static final String PHANTOMJS = "phantomjs";
    public static final String OPERA = "opera";

    public static void addListener(WebDriverEventListener listener) {
        webdriverContainer.addListener(listener);
    }

    public static void setWebDriver(WebDriver webDriver) {
        webdriverContainer.setWebDriver(webDriver);
    }

    public static WebDriver getWebDriver() {
        return webdriverContainer.getWebDriver();
    }

    public static void closeWebDriver() {
        webdriverContainer.closeWebDriver();
    }

    public static boolean ie() {
        return INTERNET_EXPLORER.equalsIgnoreCase(Configuration.browser);
    }

    public static boolean isHeadless() {
        return WebDriverRunner.htmlUnit() || WebDriverRunner.phantomjs();
    }

    public static boolean htmlUnit() {
        return Configuration.browser != null && Configuration.browser.startsWith(HTMLUNIT);
    }

    public static boolean phantomjs() {
        return PHANTOMJS.equalsIgnoreCase(Configuration.browser);
    }

    public static void clearBrowserCache() {
        webdriverContainer.clearBrowserCache();
    }

    public static String source() {
        return webdriverContainer.getPageSource();
    }

    public static String url() {
        return webdriverContainer.getCurrentUrl();
    }

    public static String takeScreenShot(String className, String methodName) {
        return screenshots.takeScreenShot(className, methodName);
    }

    public static String takeScreenShot(String fileName) {
        return screenshots.takeScreenShot(fileName);
    }
}

