/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.Selectors;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.ex.ElementNotFound;
import com.codeborne.selenide.ex.ElementShould;
import com.codeborne.selenide.ex.ElementShouldNot;
import com.codeborne.selenide.impl.BySelectorCollection;
import com.codeborne.selenide.impl.Cleanup;
import com.codeborne.selenide.impl.Describe;
import com.codeborne.selenide.impl.WaitingSelenideElement;
import com.codeborne.selenide.impl.WebElementProxy;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.openqa.selenium.By;
import org.openqa.selenium.InvalidSelectorException;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.Point;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;

abstract class AbstractSelenideElement
implements InvocationHandler {
    AbstractSelenideElement() {
    }

    abstract WebElement getDelegate();

    abstract WebElement getActualDelegate() throws NoSuchElementException, IndexOutOfBoundsException;

    abstract String getSearchCriteria();

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("setValue".equals(method.getName())) {
            this.setValue((String)args[0]);
            return proxy;
        }
        if ("val".equals(method.getName())) {
            if (args == null || args.length == 0) {
                return this.getDelegate().getAttribute("value");
            }
            this.setValue((String)args[0]);
            return proxy;
        }
        if ("attr".equals(method.getName())) {
            return this.getDelegate().getAttribute((String)args[0]);
        }
        if ("name".equals(method.getName())) {
            return this.getDelegate().getAttribute("name");
        }
        if ("data".equals(method.getName())) {
            return this.getDelegate().getAttribute("data-" + args[0]);
        }
        if ("append".equals(method.getName())) {
            this.append((String)args[0]);
            return proxy;
        }
        if ("pressEnter".equals(method.getName())) {
            this.getDelegate().sendKeys(new CharSequence[]{Keys.ENTER});
            return proxy;
        }
        if ("pressTab".equals(method.getName())) {
            this.getDelegate().sendKeys(new CharSequence[]{Keys.TAB});
            return proxy;
        }
        if ("followLink".equals(method.getName())) {
            this.followLink();
            return null;
        }
        if ("text".equals(method.getName())) {
            return this.getDelegate().getText();
        }
        if ("should".equals(method.getName())) {
            return this.should(proxy, "", (Condition[])args[0]);
        }
        if ("shouldHave".equals(method.getName())) {
            return this.should(proxy, "have ", (Condition[])args[0]);
        }
        if ("shouldBe".equals(method.getName())) {
            return this.should(proxy, "be ", (Condition[])args[0]);
        }
        if ("shouldNot".equals(method.getName())) {
            return this.shouldNot(proxy, "", (Condition[])args[0]);
        }
        if ("shouldNotHave".equals(method.getName())) {
            return this.shouldNot(proxy, "have ", (Condition[])args[0]);
        }
        if ("shouldNotBe".equals(method.getName())) {
            return this.shouldNot(proxy, "be ", (Condition[])args[0]);
        }
        if ("find".equals(method.getName()) || "$".equals(method.getName())) {
            return args.length == 1 ? this.find((SelenideElement)proxy, args[0], 0) : this.find((SelenideElement)proxy, args[0], (Integer)args[1]);
        }
        if ("findAll".equals(method.getName()) || "$$".equals(method.getName())) {
            SelenideElement parent = (SelenideElement)proxy;
            return new ElementsCollection(new BySelectorCollection(parent, this.getSelector(args[0])));
        }
        if ("toString".equals(method.getName())) {
            return this.describe();
        }
        if ("exists".equals(method.getName())) {
            return this.exists();
        }
        if ("isDisplayed".equals(method.getName())) {
            return this.isDisplayed();
        }
        if ("uploadFromClasspath".equals(method.getName())) {
            return this.uploadFromClasspath(this.getDelegate(), (String)args[0]);
        }
        if ("selectOption".equals(method.getName())) {
            this.selectOptionByText(this.getDelegate(), (String)args[0]);
            return null;
        }
        if ("selectOptionByValue".equals(method.getName())) {
            this.selectOptionByValue(this.getDelegate(), (String)args[0]);
            return null;
        }
        if ("getSelectedOption".equals(method.getName())) {
            return this.getSelectedOption(this.getDelegate());
        }
        if ("getSelectedValue".equals(method.getName())) {
            return this.getSelectedValue(this.getDelegate());
        }
        if ("getSelectedText".equals(method.getName())) {
            return this.getSelectedText(this.getDelegate());
        }
        if ("toWebElement".equals(method.getName())) {
            return this.getActualDelegate();
        }
        if ("waitUntil".equals(method.getName())) {
            this.waitUntil("", (Condition)args[0], (Long)args[1]);
            return proxy;
        }
        if ("waitWhile".equals(method.getName())) {
            this.waitWhile("", (Condition)args[0], (Long)args[1]);
            return proxy;
        }
        if ("scrollTo".equals(method.getName())) {
            this.scrollTo();
            return proxy;
        }
        if ("download".equals(method.getName())) {
            return this.download();
        }
        if ("click".equals(method.getName())) {
            this.click();
            return null;
        }
        return AbstractSelenideElement.delegateMethod(this.getDelegate(), method, args);
    }

    private WebElement waitForElement() {
        return this.waitUntil("be ", Condition.visible, Configuration.timeout);
    }

    protected void click() {
        this.waitForElement().click();
    }

    protected void followLink() {
        WebElement link = this.waitForElement();
        String href = link.getAttribute("href");
        link.click();
        if (href != null) {
            Selenide.open(href);
        }
    }

    protected void setValue(String text) {
        WebElement element = this.waitForElement();
        element.clear();
        element.sendKeys(new CharSequence[]{text});
        this.fireEvent("change");
    }

    protected void append(String text) {
        WebElement element = this.waitForElement();
        element.sendKeys(new CharSequence[]{text});
        this.fireEvent("change");
    }

    protected void fireEvent(String event) {
        String jsCodeToTriggerEvent = "if (document.createEventObject){\n  var evt = document.createEventObject();\n  return document.activeElement.fireEvent('on" + event + "', evt);\n" + "}\n" + "else{\n" + "  var evt = document.createEvent('HTMLEvents');\n " + "  evt.initEvent('" + event + "', true, true );\n " + "  return !document.activeElement.dispatchEvent(evt);\n" + '}';
        Selenide.executeJavaScript(jsCodeToTriggerEvent);
    }

    protected Object should(Object proxy, String prefix, Condition ... conditions) {
        for (Condition condition : conditions) {
            this.waitUntil(prefix, condition, Configuration.timeout);
        }
        return proxy;
    }

    protected Object shouldNot(Object proxy, String prefix, Condition ... conditions) {
        for (Condition condition : conditions) {
            this.waitWhile(prefix, condition, Configuration.timeout);
        }
        return proxy;
    }

    protected Object uploadFromClasspath(WebElement inputField, String fileName) throws URISyntaxException {
        if (!"input".equalsIgnoreCase(inputField.getTagName())) {
            throw new IllegalArgumentException("Cannot upload file because " + Describe.describe(inputField) + " is not an INPUT");
        }
        URL resource = Thread.currentThread().getContextClassLoader().getResource(fileName);
        if (resource == null) {
            throw new IllegalArgumentException("File not found in classpath: " + fileName);
        }
        File file = new File(resource.toURI());
        inputField.sendKeys(new CharSequence[]{file.getAbsolutePath()});
        return file;
    }

    protected void selectOptionByText(WebElement selectField, String optionText) {
        Selenide.$(selectField).should(Condition.exist);
        Selenide.$(selectField).find(Selectors.byText(optionText)).shouldBe(Condition.visible);
        new Select(selectField).selectByVisibleText(optionText);
    }

    protected void selectOptionByValue(WebElement selectField, String optionValue) {
        Selenide.$(selectField).should(Condition.exist);
        Selenide.$(selectField).find(Selectors.byValue(optionValue)).shouldBe(Condition.visible);
        new Select(selectField).selectByValue(optionValue);
    }

    protected String getSelectedValue(WebElement selectElement) {
        SelenideElement option = this.getSelectedOption(selectElement);
        return option == null ? null : option.getAttribute("value");
    }

    protected String getSelectedText(WebElement selectElement) {
        SelenideElement option = this.getSelectedOption(selectElement);
        return option == null ? null : option.getText();
    }

    protected SelenideElement getSelectedOption(WebElement selectElement) {
        return WebElementProxy.wrap(new Select(selectElement).getFirstSelectedOption());
    }

    protected boolean exists() {
        try {
            return this.getActualDelegate() != null;
        }
        catch (WebDriverException elementDoesNotExist) {
            return false;
        }
        catch (IndexOutOfBoundsException invalidElementIndex) {
            return false;
        }
    }

    protected boolean isDisplayed() {
        try {
            WebElement element = this.getActualDelegate();
            return element != null && element.isDisplayed();
        }
        catch (WebDriverException elementDoesNotExist) {
            return false;
        }
        catch (IndexOutOfBoundsException invalidElementIndex) {
            return false;
        }
    }

    protected String describe() {
        try {
            return Describe.describe(this.getActualDelegate());
        }
        catch (WebDriverException elementDoesNotExist) {
            return Cleanup.of.webdriverExceptionMessage(elementDoesNotExist);
        }
        catch (IndexOutOfBoundsException invalidElementIndex) {
            return invalidElementIndex.toString();
        }
    }

    static Object delegateMethod(WebElement delegate, Method method, Object[] args) throws Throwable {
        try {
            return method.invoke((Object)delegate, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    protected WebElement waitUntil(String prefix, Condition condition, long timeoutMs) {
        WebElement element;
        this.validateTimeout(timeoutMs);
        long startTime = System.currentTimeMillis();
        do {
            if ((element = this.tryToGetElement()) != null) {
                try {
                    if (condition.apply(element)) {
                        return element;
                    }
                }
                catch (WebDriverException ignore) {
                }
                catch (IndexOutOfBoundsException ignore) {}
            } else if (condition.applyNull()) {
                return null;
            }
            Selenide.sleep(Configuration.pollingInterval);
        } while (System.currentTimeMillis() - startTime < timeoutMs);
        if (!AbstractSelenideElement.exists(element)) {
            throw new ElementNotFound(this.getSearchCriteria(), condition, timeoutMs);
        }
        throw new ElementShould(this.getSearchCriteria(), prefix, condition, element, timeoutMs);
    }

    protected void waitWhile(String prefix, Condition condition, long timeoutMs) {
        WebElement element;
        this.validateTimeout(timeoutMs);
        long startTime = System.currentTimeMillis();
        do {
            if ((element = this.tryToGetElement()) != null) {
                try {
                    if (!condition.apply(element)) {
                        return;
                    }
                }
                catch (WebDriverException ignore) {
                }
                catch (IndexOutOfBoundsException ignore) {}
            } else if (!condition.applyNull()) {
                return;
            }
            Selenide.sleep(Configuration.pollingInterval);
        } while (System.currentTimeMillis() - startTime < timeoutMs);
        if (!AbstractSelenideElement.exists(element)) {
            throw new ElementNotFound(this.getSearchCriteria(), Condition.not(condition), timeoutMs);
        }
        throw new ElementShouldNot(this.getSearchCriteria(), prefix, condition, element, timeoutMs);
    }

    static boolean exists(WebElement element) {
        try {
            if (element == null) {
                return false;
            }
            element.isDisplayed();
            return true;
        }
        catch (WebDriverException e) {
            return false;
        }
    }

    protected void validateTimeout(long timeoutMs) {
        if (timeoutMs < 100L) {
            throw new IllegalArgumentException("Invalid timeout: " + timeoutMs + "ms. Check that your timeout is in milliseconds.");
        }
    }

    protected WebElement tryToGetElement() {
        try {
            return this.getActualDelegate();
        }
        catch (InvalidSelectorException invalidSelector) {
            throw invalidSelector;
        }
        catch (NoSuchElementException ignore) {
            return null;
        }
        catch (WebDriverException ignore) {
            return null;
        }
        catch (IndexOutOfBoundsException ignore) {
            return null;
        }
    }

    protected WebElement find(SelenideElement proxy, Object arg, int index) {
        By criteria = arg instanceof By ? (By)arg : By.cssSelector((String)((String)arg));
        return WaitingSelenideElement.wrap((SearchContext)proxy, criteria, index);
    }

    protected By getSelector(Object arg) {
        return arg instanceof By ? (By)arg : By.cssSelector((String)((String)arg));
    }

    protected void scrollTo() {
        Point location = this.getDelegate().getLocation();
        Selenide.executeJavaScript("window.scrollTo(" + location.getX() + ", " + location.getY() + ')');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File download() throws IOException, URISyntaxException {
        String fileToDownloadLocation = this.getDelegate().getAttribute("href");
        if (fileToDownloadLocation.trim().isEmpty()) {
            throw new IllegalArgumentException("The element does not have href attribute");
        }
        URL fileToDownload = new URL(fileToDownloadLocation);
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpGet httpGet = new HttpGet(fileToDownloadLocation);
        BasicHttpContext localContext = new BasicHttpContext();
        localContext.setAttribute("http.cookie-store", (Object)this.mimicCookieState());
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet, (HttpContext)localContext);
        System.out.println("DOWNLOAD HEADERS:");
        for (Header header : response.getAllHeaders()) {
            System.out.println(header.getName() + '=' + header.getValue());
        }
        File downloadedFile = new File(Configuration.reportsFolder, this.getFileName(fileToDownload, (HttpResponse)response));
        if (!downloadedFile.canWrite()) {
            downloadedFile.setWritable(true);
        }
        try {
            int httpStatusOfLastDownloadAttempt = response.getStatusLine().getStatusCode();
            FileUtils.copyInputStreamToFile((InputStream)response.getEntity().getContent(), (File)downloadedFile);
        }
        finally {
            response.getEntity().getContent().close();
        }
        return downloadedFile;
    }

    private String getFileName(URL fileToDownload, HttpResponse response) {
        for (Header header : response.getAllHeaders()) {
            if (!"Content-Disposition".equals(header.getName()) || !header.getValue().matches(".*filename=\"(.*)\".*")) continue;
            return header.getValue().replaceFirst(".*filename=\"(.*)\".*", "$1");
        }
        return fileToDownload.getFile().replaceFirst("/|\\\\", "");
    }

    private BasicCookieStore mimicCookieState() {
        Set seleniumCookieSet = WebDriverRunner.getWebDriver().manage().getCookies();
        BasicCookieStore mimicWebDriverCookieStore = new BasicCookieStore();
        for (org.openqa.selenium.Cookie seleniumCookie : seleniumCookieSet) {
            BasicClientCookie duplicateCookie = new BasicClientCookie(seleniumCookie.getName(), seleniumCookie.getValue());
            duplicateCookie.setDomain(seleniumCookie.getDomain());
            duplicateCookie.setSecure(seleniumCookie.isSecure());
            duplicateCookie.setExpiryDate(seleniumCookie.getExpiry());
            duplicateCookie.setPath(seleniumCookie.getPath());
            mimicWebDriverCookieStore.addCookie((Cookie)duplicateCookie);
        }
        return mimicWebDriverCookieStore;
    }
}

