/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.WebDriverRunner;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.Augmenter;
import org.openqa.selenium.remote.RemoteWebDriver;

public class ScreenShotLaboratory {
    public String takeScreenShot(String className, String methodName) {
        return this.takeScreenShot(this.getScreenshotFileName(className, methodName));
    }

    protected String getScreenshotFileName(String className, String methodName) {
        return className.replace('.', File.separatorChar) + File.separatorChar + methodName;
    }

    public String takeScreenShot(String fileName) {
        WebDriver remoteDriver;
        WebDriver webdriver = WebDriverRunner.getWebDriver();
        if (webdriver == null) {
            System.err.println("Cannot take screenshot because browser is not started");
            return null;
        }
        File targetFile = new File(Configuration.reportsFolder, fileName + ".html");
        try {
            this.writeToFile(webdriver.getPageSource(), targetFile);
        }
        catch (Exception e) {
            System.err.println(e);
        }
        if (webdriver instanceof TakesScreenshot) {
            targetFile = this.takeScreenshotImage((TakesScreenshot)webdriver, fileName, targetFile);
        } else if (webdriver instanceof RemoteWebDriver && (remoteDriver = new Augmenter().augment(webdriver)) instanceof TakesScreenshot) {
            targetFile = this.takeScreenshotImage((TakesScreenshot)remoteDriver, fileName, targetFile);
        }
        return targetFile.getAbsolutePath();
    }

    protected File takeScreenshotImage(TakesScreenshot driver, String fileName, File targetFile) {
        try {
            File scrFile = (File)driver.getScreenshotAs(OutputType.FILE);
            File imageFile = new File(Configuration.reportsFolder, fileName + ".png");
            this.copyFile(scrFile, imageFile);
            return imageFile;
        }
        catch (Exception e) {
            System.err.println(e);
            return targetFile;
        }
    }

    protected void copyFile(File sourceFile, File targetFile) throws IOException {
        this.copyFile(new FileInputStream(sourceFile), targetFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyFile(InputStream in, File targetFile) throws IOException {
        this.ensureFolderExists(targetFile);
        byte[] buffer = new byte[1024];
        try {
            FileOutputStream out = new FileOutputStream(targetFile);
            try {
                int len;
                while ((len = in.read(buffer)) != -1) {
                    out.write(buffer, 0, len);
                }
            }
            finally {
                out.close();
            }
        }
        finally {
            in.close();
        }
    }

    protected void writeToFile(String content, File targetFile) throws IOException {
        this.copyFile(new ByteArrayInputStream(content.getBytes()), targetFile);
    }

    protected File ensureFolderExists(File targetFile) {
        File folder = targetFile.getParentFile();
        if (!folder.exists()) {
            System.err.println("Creating folder: " + folder);
            if (!folder.mkdirs()) {
                System.err.println("Failed to create " + folder);
            }
        }
        return targetFile;
    }
}

