/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.ElementsContainer;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.impl.SelenideElementListProxy;
import com.codeborne.selenide.impl.WaitingSelenideElement;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.FindBys;
import org.openqa.selenium.support.PageFactory;
import org.openqa.selenium.support.pagefactory.Annotations;
import org.openqa.selenium.support.pagefactory.DefaultElementLocatorFactory;
import org.openqa.selenium.support.pagefactory.DefaultFieldDecorator;
import org.openqa.selenium.support.pagefactory.ElementLocatorFactory;
import org.openqa.selenium.support.pagefactory.FieldDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelenideFieldDecorator
extends DefaultFieldDecorator {
    private final SearchContext searchContext;

    public SelenideFieldDecorator(SearchContext searchContext) {
        super((ElementLocatorFactory)new DefaultElementLocatorFactory(searchContext));
        this.searchContext = searchContext;
    }

    public Object decorate(ClassLoader loader, Field field) {
        By selector = new Annotations(field).buildBy();
        if (WebElement.class.isAssignableFrom(field.getType())) {
            return WaitingSelenideElement.wrap(this.searchContext, selector, 0);
        }
        if (ElementsContainer.class.isAssignableFrom(field.getType())) {
            return this.createElementsContainer(selector, field);
        }
        if (this.isDecoratableList(field, ElementsContainer.class)) {
            return this.createElementsContainerList(field, selector);
        }
        if (this.isDecoratableList(field, SelenideElement.class)) {
            return SelenideElementListProxy.wrap(this.factory.createLocator(field));
        }
        return super.decorate(loader, field);
    }

    private List<ElementsContainer> createElementsContainerList(Field field, By selector) {
        try {
            ArrayList<ElementsContainer> result = new ArrayList<ElementsContainer>();
            Class<?> listType = this.getListGenericType(field);
            List<SelenideElement> selfList = SelenideElementListProxy.wrap(this.factory.createLocator(field));
            for (SelenideElement element : selfList) {
                result.add(this.initElementsContainer(listType, element));
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create elements container list for field " + field.getName(), e);
        }
    }

    private ElementsContainer createElementsContainer(By selector, Field field) {
        try {
            SelenideElement self = WaitingSelenideElement.wrap(this.searchContext, selector, 0);
            return this.initElementsContainer(field.getType(), self);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create elements container for field " + field.getName(), e);
        }
    }

    private ElementsContainer initElementsContainer(Class<?> type, SelenideElement self) throws InstantiationException, IllegalAccessException {
        ElementsContainer result = (ElementsContainer)type.newInstance();
        PageFactory.initElements((FieldDecorator)new SelenideFieldDecorator((SearchContext)self), (Object)result);
        result.setSelf(self);
        return result;
    }

    private boolean isDecoratableList(Field field, Class<?> type) {
        if (!List.class.isAssignableFrom(field.getType())) {
            return false;
        }
        Class<?> listType = this.getListGenericType(field);
        return listType != null && type.isAssignableFrom(listType) && (field.getAnnotation(FindBy.class) != null || field.getAnnotation(FindBys.class) != null);
    }

    private Class<?> getListGenericType(Field field) {
        Type genericType = field.getGenericType();
        if (!(genericType instanceof ParameterizedType)) {
            return null;
        }
        return (Class)((ParameterizedType)genericType).getActualTypeArguments()[0];
    }
}

