/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.testng;

import com.codeborne.selenide.Screenshots;
import com.codeborne.selenide.ex.ErrorMessages;
import org.testng.ITestResult;
import org.testng.reporters.ExitCodeListener;

public class ScreenShooter
extends ExitCodeListener {
    public static boolean captureSuccessfulTests;

    public void onTestStart(ITestResult result) {
        super.onTestStart(result);
        String className = result.getMethod().getTestClass().getName();
        String methodName = result.getMethod().getMethodName();
        Screenshots.startContext(className, methodName);
    }

    public void onTestFailure(ITestResult result) {
        super.onTestFailure(result);
        Screenshots.finishContext();
    }

    public void onTestSuccess(ITestResult result) {
        super.onTestSuccess(result);
        if (captureSuccessfulTests) {
            System.out.println(ErrorMessages.screenshot());
        }
        Screenshots.finishContext();
    }
}

