package com.codeborne.selenide.ex;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.impl.Describe;
import org.openqa.selenium.WebElement;

import static com.codeborne.selenide.ex.ErrorMessages.actualValue;

public class ElementShouldNot extends UIAssertionError {
  public ElementShouldNot(String searchCriteria, String prefix, Condition expectedCondition, WebElement element, long timeoutMs) {
    super("Element should not " + prefix + expectedCondition + " {" + searchCriteria + '}' +
        "\nElement: '" + Describe.describe(element) + '\'' +
        actualValue(expectedCondition, element), timeoutMs);
  }

  @Override
  public String toString() {
    return getMessage();
  }
}
