/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import java.util.logging.Logger;

public class Configuration {
    private static final Logger LOG = Logger.getLogger(Configuration.class.getName());
    public static String baseUrl = System.getProperty("selenide.baseUrl", "http://localhost:8080");
    public static long timeout = Long.parseLong(System.getProperty("selenide.timeout", "4000"));
    public static long pollingInterval = Long.parseLong(System.getProperty("selenide.pollingInterval", "100"));
    public static boolean holdBrowserOpen = Boolean.getBoolean("selenide.holdBrowserOpen");
    public static String browser = System.getProperty("selenide.browser", System.getProperty("browser", "firefox"));
    public static String remote = System.getProperty("remote");
    public static boolean startMaximized = Boolean.parseBoolean(System.getProperty("selenide.start-maximized", "true"));
    public static boolean screenshots = Boolean.parseBoolean(System.getProperty("selenide.screenshots", "true"));
    public static String reportsFolder = System.getProperty("selenide.reports", "build/reports/tests");
    public static String reportsUrl = Configuration.getReportsUrl();
    public static boolean dismissModalDialogs = Boolean.parseBoolean(System.getProperty("selenide.dismissModalDialogs", "false"));

    static String getReportsUrl() {
        String reportsUrl = System.getProperty("selenide.reportsUrl");
        if (Configuration.isEmpty(reportsUrl)) {
            reportsUrl = Configuration.getJenkinsReportsUrl();
            if (Configuration.isEmpty(reportsUrl)) {
                LOG.info("Variable selenide.reportsUrl not found");
            }
        } else {
            LOG.info("Using variable selenide.reportsUrl=" + reportsUrl);
        }
        return reportsUrl;
    }

    private static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    private static String getJenkinsReportsUrl() {
        String build_url = System.getProperty("BUILD_URL");
        if (!Configuration.isEmpty(build_url)) {
            LOG.info("Using Jenkins BUILD_URL: " + build_url);
            return build_url + "artifact/";
        }
        LOG.info("No BUILD_URL variable found. It's not Jenkins.");
        return null;
    }
}

