/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.Selectors;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.ex.ElementNotFound;
import com.codeborne.selenide.ex.ElementShould;
import com.codeborne.selenide.ex.ElementShouldNot;
import com.codeborne.selenide.impl.BySelectorCollection;
import com.codeborne.selenide.impl.Cleanup;
import com.codeborne.selenide.impl.Describe;
import com.codeborne.selenide.impl.FileDownloader;
import com.codeborne.selenide.impl.WaitingSelenideElement;
import com.codeborne.selenide.impl.WebElementProxy;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.Point;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;

abstract class AbstractSelenideElement
implements InvocationHandler {
    AbstractSelenideElement() {
    }

    abstract WebElement getDelegate();

    abstract WebElement getActualDelegate() throws NoSuchElementException, IndexOutOfBoundsException;

    abstract String getSearchCriteria();

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("setValue".equals(method.getName())) {
            this.setValue((String)args[0]);
            return proxy;
        }
        if ("val".equals(method.getName())) {
            if (args == null || args.length == 0) {
                return this.getDelegate().getAttribute("value");
            }
            this.setValue((String)args[0]);
            return proxy;
        }
        if ("attr".equals(method.getName())) {
            return this.getDelegate().getAttribute((String)args[0]);
        }
        if ("name".equals(method.getName())) {
            return this.getDelegate().getAttribute("name");
        }
        if ("data".equals(method.getName())) {
            return this.getDelegate().getAttribute("data-" + args[0]);
        }
        if ("append".equals(method.getName())) {
            this.append((String)args[0]);
            return proxy;
        }
        if ("pressEnter".equals(method.getName())) {
            this.getDelegate().sendKeys(new CharSequence[]{Keys.ENTER});
            return proxy;
        }
        if ("pressTab".equals(method.getName())) {
            this.getDelegate().sendKeys(new CharSequence[]{Keys.TAB});
            return proxy;
        }
        if ("followLink".equals(method.getName())) {
            this.followLink();
            return null;
        }
        if ("text".equals(method.getName())) {
            return this.getDelegate().getText();
        }
        if ("innerText".equals(method.getName())) {
            return this.getInnerText();
        }
        if ("innerHtml".equals(method.getName())) {
            return this.getInnerHtml();
        }
        if ("should".equals(method.getName())) {
            return this.should(proxy, "", (Condition[])args[0]);
        }
        if ("shouldHave".equals(method.getName())) {
            return this.should(proxy, "have ", (Condition[])args[0]);
        }
        if ("shouldBe".equals(method.getName())) {
            return this.should(proxy, "be ", (Condition[])args[0]);
        }
        if ("shouldNot".equals(method.getName())) {
            return this.shouldNot(proxy, "", (Condition[])args[0]);
        }
        if ("shouldNotHave".equals(method.getName())) {
            return this.shouldNot(proxy, "have ", (Condition[])args[0]);
        }
        if ("shouldNotBe".equals(method.getName())) {
            return this.shouldNot(proxy, "be ", (Condition[])args[0]);
        }
        if ("find".equals(method.getName()) || "$".equals(method.getName())) {
            return args.length == 1 ? this.find((SelenideElement)proxy, args[0], 0) : this.find((SelenideElement)proxy, args[0], (Integer)args[1]);
        }
        if ("findAll".equals(method.getName()) || "$$".equals(method.getName())) {
            SelenideElement parent = (SelenideElement)proxy;
            return new ElementsCollection(new BySelectorCollection(parent, this.getSelector(args[0])));
        }
        if ("toString".equals(method.getName())) {
            return this.describe();
        }
        if ("exists".equals(method.getName())) {
            return this.exists();
        }
        if ("isDisplayed".equals(method.getName())) {
            return this.isDisplayed();
        }
        if ("is".equals(method.getName()) || "has".equals(method.getName())) {
            return this.matches((Condition)args[0]);
        }
        if ("setSelected".equals(method.getName())) {
            this.setSelected((Boolean)args[0]);
            return proxy;
        }
        if ("uploadFromClasspath".equals(method.getName())) {
            return this.uploadFromClasspath(this.getDelegate(), (String)args[0]);
        }
        if ("selectOption".equals(method.getName())) {
            this.selectOptionByText(this.getDelegate(), (String)args[0]);
            return null;
        }
        if ("selectOptionByValue".equals(method.getName())) {
            this.selectOptionByValue(this.getDelegate(), (String)args[0]);
            return null;
        }
        if ("getSelectedOption".equals(method.getName())) {
            return this.getSelectedOption(this.getDelegate());
        }
        if ("getSelectedValue".equals(method.getName())) {
            return this.getSelectedValue(this.getDelegate());
        }
        if ("getSelectedText".equals(method.getName())) {
            return this.getSelectedText(this.getDelegate());
        }
        if ("toWebElement".equals(method.getName())) {
            return this.getActualDelegate();
        }
        if ("waitUntil".equals(method.getName())) {
            this.waitUntil("", (Condition)args[0], (Long)args[1]);
            return proxy;
        }
        if ("waitWhile".equals(method.getName())) {
            this.waitWhile("", (Condition)args[0], (Long)args[1]);
            return proxy;
        }
        if ("scrollTo".equals(method.getName())) {
            this.scrollTo();
            return proxy;
        }
        if ("download".equals(method.getName())) {
            return this.download();
        }
        if ("click".equals(method.getName())) {
            this.click();
            return null;
        }
        if ("contextClick".equals(method.getName())) {
            this.contextClick();
            return null;
        }
        if ("getWrappedElement".equals(method.getName())) {
            return this.getActualDelegate();
        }
        return AbstractSelenideElement.delegateMethod(this.getDelegate(), method, args);
    }

    protected boolean matches(Condition condition) {
        try {
            WebElement element = this.tryToGetElement();
            if (element != null) {
                return condition.apply(element);
            }
        }
        catch (WebDriverException elementNotFound) {
            if (Cleanup.of.isInvalidSelectorError(elementNotFound)) {
                throw Cleanup.of.wrap((RuntimeException)((Object)elementNotFound));
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return condition.applyNull();
    }

    protected void setSelected(boolean selected) {
        WebElement element = this.tryToGetElement();
        if (element.isSelected() ^ selected) {
            element.click();
        }
    }

    protected String getInnerText() {
        WebElement element = this.waitUntil("", Condition.exist, Configuration.timeout);
        if (WebDriverRunner.htmlUnit()) {
            return (String)Selenide.executeJavaScript("return arguments[0].innerText", element);
        }
        if (WebDriverRunner.ie()) {
            return element.getAttribute("innerText");
        }
        return element.getAttribute("textContent");
    }

    protected String getInnerHtml() {
        WebElement element = this.waitUntil("", Condition.exist, Configuration.timeout);
        if (WebDriverRunner.htmlUnit()) {
            return (String)Selenide.executeJavaScript("return arguments[0].innerHTML", element);
        }
        return element.getAttribute("innerHTML");
    }

    protected WebElement waitForElement() {
        return this.waitUntil("be ", Condition.visible, Configuration.timeout);
    }

    protected void click() {
        this.waitForElement().click();
    }

    protected void contextClick() {
        Selenide.actions().contextClick(this.waitForElement()).perform();
    }

    protected void followLink() {
        WebElement link = this.waitForElement();
        String href = link.getAttribute("href");
        link.click();
        if (href != null) {
            Selenide.open(href);
        }
    }

    protected void setValue(String text) {
        WebElement element = this.waitForElement();
        element.clear();
        element.sendKeys(new CharSequence[]{text});
        this.fireEvent("change");
    }

    protected void append(String text) {
        WebElement element = this.waitForElement();
        element.sendKeys(new CharSequence[]{text});
        this.fireEvent("change");
    }

    protected void fireEvent(String event) {
        String jsCodeToTriggerEvent = "if (document.createEventObject){\n  var evt = document.createEventObject();\n  return document.activeElement.fireEvent('on" + event + "', evt);\n" + "}\n" + "else{\n" + "  var evt = document.createEvent('HTMLEvents');\n " + "  evt.initEvent('" + event + "', true, true );\n " + "  return !document.activeElement.dispatchEvent(evt);\n" + '}';
        Selenide.executeJavaScript(jsCodeToTriggerEvent, new Object[0]);
    }

    protected Object should(Object proxy, String prefix, Condition ... conditions) {
        for (Condition condition : conditions) {
            this.waitUntil(prefix, condition, Configuration.timeout);
        }
        return proxy;
    }

    protected Object shouldNot(Object proxy, String prefix, Condition ... conditions) {
        for (Condition condition : conditions) {
            this.waitWhile(prefix, condition, Configuration.timeout);
        }
        return proxy;
    }

    protected Object uploadFromClasspath(WebElement inputField, String fileName) throws URISyntaxException {
        if (!"input".equalsIgnoreCase(inputField.getTagName())) {
            throw new IllegalArgumentException("Cannot upload file because " + Describe.describe(inputField) + " is not an INPUT");
        }
        URL resource = Thread.currentThread().getContextClassLoader().getResource(fileName);
        if (resource == null) {
            throw new IllegalArgumentException("File not found in classpath: " + fileName);
        }
        File file = new File(resource.toURI());
        inputField.sendKeys(new CharSequence[]{file.getAbsolutePath()});
        return file;
    }

    protected void selectOptionByText(WebElement selectField, String optionText) {
        Selenide.$(selectField).should(Condition.exist);
        Selenide.$(selectField).find(Selectors.byText(optionText)).shouldBe(Condition.visible);
        new Select(selectField).selectByVisibleText(optionText);
    }

    protected void selectOptionByValue(WebElement selectField, String optionValue) {
        Selenide.$(selectField).should(Condition.exist);
        Selenide.$(selectField).find(Selectors.byValue(optionValue)).shouldBe(Condition.visible);
        new Select(selectField).selectByValue(optionValue);
    }

    protected String getSelectedValue(WebElement selectElement) {
        SelenideElement option = this.getSelectedOption(selectElement);
        return option == null ? null : option.getAttribute("value");
    }

    protected String getSelectedText(WebElement selectElement) {
        SelenideElement option = this.getSelectedOption(selectElement);
        return option == null ? null : option.getText();
    }

    protected SelenideElement getSelectedOption(WebElement selectElement) {
        return WebElementProxy.wrap(new Select(selectElement).getFirstSelectedOption());
    }

    protected boolean exists() {
        try {
            return this.getActualDelegate() != null;
        }
        catch (WebDriverException elementNotFound) {
            if (Cleanup.of.isInvalidSelectorError(elementNotFound)) {
                throw Cleanup.of.wrap((RuntimeException)((Object)elementNotFound));
            }
            return false;
        }
        catch (IndexOutOfBoundsException invalidElementIndex) {
            return false;
        }
    }

    protected boolean isDisplayed() {
        try {
            WebElement element = this.getActualDelegate();
            return element != null && element.isDisplayed();
        }
        catch (WebDriverException elementNotFound) {
            if (Cleanup.of.isInvalidSelectorError(elementNotFound)) {
                throw Cleanup.of.wrap((RuntimeException)((Object)elementNotFound));
            }
            return false;
        }
        catch (IndexOutOfBoundsException invalidElementIndex) {
            return false;
        }
    }

    protected String describe() {
        try {
            return Describe.describe(this.getActualDelegate());
        }
        catch (WebDriverException elementDoesNotExist) {
            return Cleanup.of.webdriverExceptionMessage(elementDoesNotExist);
        }
        catch (IndexOutOfBoundsException invalidElementIndex) {
            return invalidElementIndex.toString();
        }
    }

    static Object delegateMethod(WebElement delegate, Method method, Object[] args) throws Throwable {
        try {
            return method.invoke((Object)delegate, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    /*
     * Unable to fully structure code
     */
    protected WebElement waitUntil(String prefix, Condition condition, long timeoutMs) {
        startTime = System.currentTimeMillis();
        do {
            if ((element = this.tryToGetElement()) != null) {
                try {
                    if (!condition.apply(element)) ** GOTO lbl14
                    return element;
                }
                catch (WebDriverException elementNotFound) {
                    if (!Cleanup.of.isInvalidSelectorError(elementNotFound)) ** GOTO lbl14
                    throw Cleanup.of.wrap((RuntimeException)elementNotFound);
                }
                catch (IndexOutOfBoundsException ignore) {}
            } else if (condition.applyNull()) {
                return null;
            }
lbl14:
            // 5 sources

            Selenide.sleep(Configuration.pollingInterval);
        } while (System.currentTimeMillis() - startTime < timeoutMs);
        if (!this.exists(element)) {
            throw new ElementNotFound(this.getSearchCriteria(), condition, timeoutMs);
        }
        throw new ElementShould(this.getSearchCriteria(), prefix, condition, element, timeoutMs);
    }

    /*
     * Unable to fully structure code
     */
    protected void waitWhile(String prefix, Condition condition, long timeoutMs) {
        startTime = System.currentTimeMillis();
        do {
            if ((element = this.tryToGetElement()) != null) {
                try {
                    if (condition.apply(element)) ** GOTO lbl14
                    return;
                }
                catch (WebDriverException elementNotFound) {
                    if (!Cleanup.of.isInvalidSelectorError(elementNotFound)) ** GOTO lbl14
                    throw Cleanup.of.wrap((RuntimeException)elementNotFound);
                }
                catch (IndexOutOfBoundsException ignore) {}
            } else if (!condition.applyNull()) {
                return;
            }
lbl14:
            // 5 sources

            Selenide.sleep(Configuration.pollingInterval);
        } while (System.currentTimeMillis() - startTime < timeoutMs);
        if (!this.exists(element)) {
            throw new ElementNotFound(this.getSearchCriteria(), Condition.not(condition), timeoutMs);
        }
        throw new ElementShouldNot(this.getSearchCriteria(), prefix, condition, element, timeoutMs);
    }

    boolean exists(WebElement element) {
        try {
            if (element == null) {
                return false;
            }
            element.isDisplayed();
            return true;
        }
        catch (WebDriverException elementNotFound) {
            if (Cleanup.of.isInvalidSelectorError(elementNotFound)) {
                throw Cleanup.of.wrap((RuntimeException)((Object)elementNotFound));
            }
            return false;
        }
    }

    protected WebElement tryToGetElement() {
        try {
            return this.getActualDelegate();
        }
        catch (WebDriverException elementNotFound) {
            if (Cleanup.of.isInvalidSelectorError(elementNotFound)) {
                throw Cleanup.of.wrap((RuntimeException)((Object)elementNotFound));
            }
            return null;
        }
        catch (IndexOutOfBoundsException ignore) {
            return null;
        }
        catch (RuntimeException e) {
            throw Cleanup.of.wrap(e);
        }
    }

    protected WebElement find(SelenideElement proxy, Object arg, int index) {
        By criteria = arg instanceof By ? (By)arg : By.cssSelector((String)((String)arg));
        return WaitingSelenideElement.wrap((SearchContext)proxy, criteria, index);
    }

    protected By getSelector(Object arg) {
        return arg instanceof By ? (By)arg : By.cssSelector((String)((String)arg));
    }

    protected void scrollTo() {
        Point location = this.getDelegate().getLocation();
        Selenide.executeJavaScript("window.scrollTo(" + location.getX() + ", " + location.getY() + ')', new Object[0]);
    }

    protected File download() throws IOException, URISyntaxException {
        return FileDownloader.instance.download(this.getDelegate());
    }
}

