/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.impl.AbstractSelenideElement;
import com.codeborne.selenide.impl.WebElementsCollection;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;

public class CollectionElement
extends AbstractSelenideElement {
    private final WebElementsCollection collection;
    private final int index;

    public static SelenideElement wrap(WebElementsCollection collection, int index) {
        return (SelenideElement)Proxy.newProxyInstance(collection.getClass().getClassLoader(), new Class[]{SelenideElement.class}, (InvocationHandler)new CollectionElement(collection, index));
    }

    CollectionElement(WebElementsCollection collection, int index) {
        this.collection = collection;
        this.index = index;
    }

    @Override
    protected WebElement getDelegate() {
        return this.collection.getActualElements().get(this.index);
    }

    @Override
    protected WebElement getActualDelegate() throws NoSuchElementException, IndexOutOfBoundsException {
        return this.getDelegate();
    }

    @Override
    String getSearchCriteria() {
        return this.collection.description() + '[' + this.index + ']';
    }

    public String toString() {
        return this.getSearchCriteria();
    }
}

