/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.WebDriverProvider;
import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.impl.Cleanup;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.internal.Killable;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.support.events.EventFiringWebDriver;
import org.openqa.selenium.support.events.WebDriverEventListener;

public class WebDriverThreadLocalContainer {
    protected List<WebDriverEventListener> listeners = new ArrayList<WebDriverEventListener>();
    protected List<WebDriver> ALL_WEB_DRIVERS = new ArrayList<WebDriver>();
    protected ThreadLocal<WebDriver> THREAD_WEB_DRIVER = new ThreadLocal();

    public WebDriverThreadLocalContainer() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                WebDriverThreadLocalContainer.this.closeAllWebDrivers();
            }
        });
    }

    public void addListener(WebDriverEventListener listener) {
        this.listeners.add(listener);
    }

    public void setWebDriver(WebDriver webDriver) {
        this.THREAD_WEB_DRIVER.set(webDriver);
        this.ALL_WEB_DRIVERS.add(webDriver);
    }

    public WebDriver getWebDriver() {
        if (this.THREAD_WEB_DRIVER.get() == null) {
            WebDriver webDriver = this.createDriver();
            this.THREAD_WEB_DRIVER.set(webDriver);
            this.ALL_WEB_DRIVERS.add(webDriver);
        }
        return this.THREAD_WEB_DRIVER.get();
    }

    public void closeWebDriver() {
        WebDriver webdriver = this.THREAD_WEB_DRIVER.get();
        if (webdriver != null) {
            this.closeWebDriver(webdriver);
        }
    }

    protected void closeAllWebDrivers() {
        while (!this.ALL_WEB_DRIVERS.isEmpty()) {
            this.closeWebDriver(this.ALL_WEB_DRIVERS.get(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeWebDriver(WebDriver webdriver) {
        this.THREAD_WEB_DRIVER.remove();
        this.ALL_WEB_DRIVERS.remove(webdriver);
        if (!Configuration.holdBrowserOpen) {
            try {
                webdriver.quit();
            }
            catch (WebDriverException cannotCloseBrowser) {
                System.err.println("Cannot close browser normally: " + Cleanup.of.webdriverExceptionMessage(cannotCloseBrowser));
            }
            finally {
                this.killBrowser(webdriver);
            }
        }
    }

    protected void killBrowser(WebDriver webdriver) {
        if (webdriver instanceof Killable) {
            try {
                ((Killable)webdriver).kill();
            }
            catch (Exception e) {
                System.err.println("Failed to kill browser " + webdriver + ':');
                e.printStackTrace();
            }
        }
    }

    public void clearBrowserCache() {
        if (this.THREAD_WEB_DRIVER.get() != null) {
            this.THREAD_WEB_DRIVER.get().manage().deleteAllCookies();
        }
    }

    public String getPageSource() {
        return this.getWebDriver().getPageSource();
    }

    public String getCurrentUrl() {
        return this.getWebDriver().getCurrentUrl();
    }

    protected WebDriver createDriver() {
        WebDriver webdriver = Configuration.remote != null ? this.createRemoteDriver(Configuration.remote, Configuration.browser) : ("chrome".equalsIgnoreCase(Configuration.browser) ? this.createChromeDriver() : ("firefox".equalsIgnoreCase(Configuration.browser) ? this.createFirefoxDriver() : (WebDriverRunner.htmlUnit() ? this.createHtmlUnitDriver() : (WebDriverRunner.ie() ? this.createInternetExplorerDriver() : ("phantomjs".equals(Configuration.browser) ? this.createPhantomJsDriver() : ("opera".equalsIgnoreCase(Configuration.browser) ? this.createOperaDriver() : this.createInstanceOf(Configuration.browser)))))));
        return this.listeners.isEmpty() ? webdriver : this.addListeners(webdriver);
    }

    protected WebDriver addListeners(WebDriver webdriver) {
        EventFiringWebDriver wrapper = new EventFiringWebDriver(webdriver);
        for (WebDriverEventListener listener : this.listeners) {
            wrapper.register(listener);
        }
        return wrapper;
    }

    protected WebDriver createChromeDriver() {
        ChromeOptions options = new ChromeOptions();
        if (Configuration.startMaximized) {
            options.addArguments(new String[]{"chrome.switches", "--start-maximized"});
        }
        return new ChromeDriver(options);
    }

    protected WebDriver createFirefoxDriver() {
        return this.maximize((WebDriver)new FirefoxDriver());
    }

    protected WebDriver createHtmlUnitDriver() {
        DesiredCapabilities capabilities = DesiredCapabilities.htmlUnit();
        capabilities.setCapability("The xpath expression '%s' selected an object of type '%s' instead of a WebElement", true);
        capabilities.setCapability("The xpath expression '%s' cannot be evaluated", false);
        capabilities.setJavascriptEnabled(true);
        if (Configuration.browser.indexOf(58) > -1) {
            String emulatedBrowser = Configuration.browser.replaceFirst("htmlunit:(.*)", "$1");
            capabilities.setVersion(emulatedBrowser);
        }
        return new HtmlUnitDriver((Capabilities)capabilities);
    }

    protected WebDriver createInternetExplorerDriver() {
        return this.maximize((WebDriver)new InternetExplorerDriver());
    }

    protected WebDriver createPhantomJsDriver() {
        return this.maximize(this.createInstanceOf("org.openqa.selenium.phantomjs.PhantomJSDriver"));
    }

    protected WebDriver createOperaDriver() {
        return this.createInstanceOf("com.opera.core.systems.OperaDriver");
    }

    protected WebDriver maximize(WebDriver driver) {
        if (Configuration.startMaximized) {
            driver.manage().window().maximize();
        }
        return driver;
    }

    protected WebDriver createInstanceOf(String className) {
        try {
            DesiredCapabilities capabilities = new DesiredCapabilities();
            capabilities.setJavascriptEnabled(true);
            capabilities.setCapability("takesScreenshot", true);
            capabilities.setCapability("acceptSslCerts", true);
            capabilities.setCapability("handlesAlerts", true);
            Class<?> clazz = Class.forName(className);
            if (WebDriverProvider.class.isAssignableFrom(clazz)) {
                return ((WebDriverProvider)clazz.newInstance()).createDriver(capabilities);
            }
            Constructor<?> constructor = Class.forName(className).getConstructor(Capabilities.class);
            return (WebDriver)constructor.newInstance(capabilities);
        }
        catch (Exception invalidClassName) {
            throw new IllegalArgumentException(invalidClassName);
        }
    }

    protected WebDriver createRemoteDriver(String remote, String browser) {
        try {
            DesiredCapabilities capabilities = new DesiredCapabilities();
            capabilities.setBrowserName(browser);
            return new RemoteWebDriver(new URL(remote), (Capabilities)capabilities);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid 'remote' parameter: " + remote, e);
        }
    }
}

