/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.WebDriverRunner;
import com.google.common.base.Objects;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicLong;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.Augmenter;
import org.openqa.selenium.remote.RemoteWebDriver;

public class ScreenShotLaboratory {
    protected AtomicLong screenshotCounter = new AtomicLong();
    protected String currentContext = "";
    protected List<String> currentContextScreenshots;
    protected List<String> allScreenshots = new ArrayList<String>();
    protected Set<String> printedErrors = new ConcurrentSkipListSet<String>();

    protected synchronized void printOnce(String action, Throwable error) {
        if (!this.printedErrors.contains(action)) {
            System.err.println("Failed to " + action + ": ");
            error.printStackTrace();
            this.printedErrors.add(action);
        } else {
            System.err.println("Failed to " + action + ": " + error);
        }
    }

    public String takeScreenShot(String className, String methodName) {
        return this.takeScreenShot(this.getScreenshotFileName(className, methodName));
    }

    protected String getScreenshotFileName(String className, String methodName) {
        return className.replace('.', File.separatorChar) + File.separatorChar + methodName + '.' + this.timestamp();
    }

    protected long timestamp() {
        return System.currentTimeMillis();
    }

    public String takeScreenShot() {
        return this.takeScreenShot(this.generateScreenshotFileName());
    }

    protected String generateScreenshotFileName() {
        return this.currentContext + this.timestamp() + "." + this.screenshotCounter.getAndIncrement();
    }

    public String takeScreenShot(String fileName) {
        WebDriver webdriver = WebDriverRunner.getWebDriver();
        if (webdriver == null) {
            System.err.println("Cannot take screenshot because browser is not started");
            return null;
        }
        File pageSource = this.savePageSourceToFile(fileName, webdriver);
        File imageFile = this.savePageImageToFile(fileName, webdriver);
        String screenshot = ((File)Objects.firstNonNull((Object)imageFile, (Object)pageSource)).getAbsolutePath();
        return this.addToHistory(screenshot);
    }

    protected File savePageImageToFile(String fileName, WebDriver webdriver) {
        WebDriver remoteDriver;
        File imageFile = null;
        if (webdriver instanceof TakesScreenshot) {
            imageFile = this.takeScreenshotImage((TakesScreenshot)webdriver, fileName);
        } else if (webdriver instanceof RemoteWebDriver && (remoteDriver = new Augmenter().augment(webdriver)) instanceof TakesScreenshot) {
            imageFile = this.takeScreenshotImage((TakesScreenshot)remoteDriver, fileName);
        }
        return imageFile;
    }

    protected File savePageSourceToFile(String fileName, WebDriver webdriver) {
        File pageSource = new File(Configuration.reportsFolder, fileName + ".html");
        try {
            this.writeToFile(webdriver.getPageSource(), pageSource);
        }
        catch (Exception e) {
            this.printOnce("savePageSourceToFile", e);
        }
        return pageSource;
    }

    protected String addToHistory(String screenshot) {
        if (this.currentContextScreenshots != null) {
            this.currentContextScreenshots.add(screenshot);
        }
        this.allScreenshots.add(screenshot);
        return screenshot;
    }

    protected File takeScreenshotImage(TakesScreenshot driver, String fileName) {
        try {
            File scrFile = (File)driver.getScreenshotAs(OutputType.FILE);
            File imageFile = new File(Configuration.reportsFolder, fileName + ".png");
            this.copyFile(scrFile, imageFile);
            return imageFile;
        }
        catch (Exception e) {
            this.printOnce("takeScreenshotImage", e);
            return null;
        }
    }

    protected void copyFile(File sourceFile, File targetFile) throws IOException {
        this.copyFile(new FileInputStream(sourceFile), targetFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyFile(InputStream in, File targetFile) throws IOException {
        this.ensureFolderExists(targetFile);
        try {
            FileOutputStream out = new FileOutputStream(targetFile);
            try {
                int len;
                byte[] buffer = new byte[1024];
                while ((len = in.read(buffer)) != -1) {
                    out.write(buffer, 0, len);
                }
            }
            finally {
                out.close();
            }
        }
        finally {
            in.close();
        }
    }

    protected void writeToFile(String content, File targetFile) throws IOException {
        this.copyFile(new ByteArrayInputStream(content.getBytes("UTF-8")), targetFile);
    }

    protected File ensureFolderExists(File targetFile) {
        File folder = targetFile.getParentFile();
        if (!folder.exists()) {
            System.err.println("Creating folder: " + folder);
            if (!folder.mkdirs()) {
                System.err.println("Failed to create " + folder);
            }
        }
        return targetFile;
    }

    public void startContext(String className, String methodName) {
        String context = className.replace('.', File.separatorChar) + File.separatorChar + methodName + File.separatorChar;
        this.startContext(context);
    }

    public void startContext(String context) {
        this.currentContext = context;
        this.currentContextScreenshots = new ArrayList<String>();
    }

    public List<String> finishContext() {
        List<String> result = this.currentContextScreenshots;
        this.currentContext = "";
        this.currentContextScreenshots = null;
        return result;
    }

    public List<String> getScreenshots() {
        return this.allScreenshots;
    }
}

