/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.commands.Commands;
import com.codeborne.selenide.ex.InvalidStateException;
import com.codeborne.selenide.ex.UIAssertionError;
import com.codeborne.selenide.impl.Cleanup;
import com.codeborne.selenide.impl.WebElementSource;
import com.codeborne.selenide.logevents.LogEvent;
import com.codeborne.selenide.logevents.SelenideLog;
import com.codeborne.selenide.logevents.SelenideLogger;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.openqa.selenium.InvalidElementStateException;
import org.openqa.selenium.WebDriverException;

class SelenideElementProxy
implements InvocationHandler {
    private static final Set<String> methodsToSkipLogging = new HashSet<String>(Arrays.asList("toWebElement", "toString"));
    private static final Set<String> methodsForSoftAssertion = new HashSet<String>(Arrays.asList("should", "shouldBe", "shouldHave", "shouldNot", "shouldNotHave", "shouldNotBe", "waitUntil", "waitWhile"));
    private final WebElementSource webElementSource;

    protected SelenideElementProxy(WebElementSource webElementSource) {
        this.webElementSource = webElementSource;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object ... args) throws Throwable {
        if (methodsToSkipLogging.contains(method.getName())) {
            return Commands.collection.execute(proxy, this.webElementSource, method.getName(), args);
        }
        long timeoutMs = this.getTimeoutMs(method, args);
        SelenideLog log = SelenideLogger.beginStep(this.webElementSource.getSearchCriteria(), method.getName(), args);
        try {
            Object result = this.dispatchAndRetry(timeoutMs, proxy, method, args);
            SelenideLogger.commitStep(log, LogEvent.EventStatus.PASSED);
            return result;
        }
        catch (Error error) {
            SelenideLogger.commitStep(log, error);
            if (Configuration.assertionMode == Configuration.AssertionMode.SOFT && methodsForSoftAssertion.contains(method.getName())) {
                return proxy;
            }
            throw UIAssertionError.wrap(error, timeoutMs);
        }
        catch (RuntimeException error) {
            SelenideLogger.commitStep(log, error);
            throw error;
        }
    }

    protected Object dispatchAndRetry(long timeoutMs, Object proxy, Method method, Object[] args) throws Throwable {
        long startTime = System.currentTimeMillis();
        while (true) {
            try {
                if (SelenideElement.class.isAssignableFrom(method.getDeclaringClass())) {
                    return Commands.collection.execute(proxy, this.webElementSource, method.getName(), args);
                }
                return method.invoke((Object)this.webElementSource.getWebElement(), args);
            }
            catch (Throwable e) {
                if (Cleanup.of.isInvalidSelectorError(e)) {
                    throw Cleanup.of.wrap(e);
                }
                Throwable lastError = e;
                Selenide.sleep(Configuration.pollingInterval);
                if (System.currentTimeMillis() - startTime <= timeoutMs) continue;
                if (lastError instanceof UIAssertionError) {
                    throw lastError;
                }
                if (lastError instanceof InvalidElementStateException) {
                    throw new InvalidStateException(lastError);
                }
                if (lastError instanceof WebDriverException) {
                    throw this.webElementSource.createElementNotFoundError(Condition.exist, lastError);
                }
                throw lastError;
            }
            break;
        }
    }

    private long getTimeoutMs(Method method, Object[] args) {
        return "waitUntil".equals(method.getName()) || "waitWhile".equals(method.getName()) ? (Long)args[args.length - 1] : Configuration.timeout;
    }
}

