/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.commands;

import com.codeborne.selenide.Command;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.commands.Append;
import com.codeborne.selenide.commands.Click;
import com.codeborne.selenide.commands.ContextClick;
import com.codeborne.selenide.commands.DoubleClick;
import com.codeborne.selenide.commands.DownloadFile;
import com.codeborne.selenide.commands.DragAndDropTo;
import com.codeborne.selenide.commands.Exists;
import com.codeborne.selenide.commands.Find;
import com.codeborne.selenide.commands.FindAll;
import com.codeborne.selenide.commands.FollowLink;
import com.codeborne.selenide.commands.GetAttribute;
import com.codeborne.selenide.commands.GetClosest;
import com.codeborne.selenide.commands.GetDataAttribute;
import com.codeborne.selenide.commands.GetInnerHtml;
import com.codeborne.selenide.commands.GetInnerText;
import com.codeborne.selenide.commands.GetName;
import com.codeborne.selenide.commands.GetParent;
import com.codeborne.selenide.commands.GetSelectedOption;
import com.codeborne.selenide.commands.GetSelectedText;
import com.codeborne.selenide.commands.GetSelectedValue;
import com.codeborne.selenide.commands.GetText;
import com.codeborne.selenide.commands.GetValue;
import com.codeborne.selenide.commands.GetWrappedElement;
import com.codeborne.selenide.commands.Hover;
import com.codeborne.selenide.commands.IsDisplayed;
import com.codeborne.selenide.commands.IsImage;
import com.codeborne.selenide.commands.Matches;
import com.codeborne.selenide.commands.PressEnter;
import com.codeborne.selenide.commands.PressEscape;
import com.codeborne.selenide.commands.PressTab;
import com.codeborne.selenide.commands.ScrollTo;
import com.codeborne.selenide.commands.SelectOptionByText;
import com.codeborne.selenide.commands.SelectOptionByValue;
import com.codeborne.selenide.commands.SelectRadio;
import com.codeborne.selenide.commands.SetSelected;
import com.codeborne.selenide.commands.SetValue;
import com.codeborne.selenide.commands.Should;
import com.codeborne.selenide.commands.ShouldBe;
import com.codeborne.selenide.commands.ShouldHave;
import com.codeborne.selenide.commands.ShouldNot;
import com.codeborne.selenide.commands.ShouldNotBe;
import com.codeborne.selenide.commands.ShouldNotHave;
import com.codeborne.selenide.commands.TakeScreenshot;
import com.codeborne.selenide.commands.ToString;
import com.codeborne.selenide.commands.ToWebElement;
import com.codeborne.selenide.commands.UploadFile;
import com.codeborne.selenide.commands.UploadFileFromClasspath;
import com.codeborne.selenide.commands.Val;
import com.codeborne.selenide.impl.WebElementSource;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Commands {
    public static Commands collection = new Commands();
    private final Map<String, Command> commands = new ConcurrentHashMap<String, Command>(128);

    public Commands() {
        this.resetDefaults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resetDefaults() {
        Commands commands = this;
        synchronized (commands) {
            this.commands.clear();
            this.addFindCommands();
            this.addClickCommands();
            this.addModifyCommands();
            this.addInfoCommands();
            this.addSelectCommands();
            this.addKeyboardCommands();
            this.addActionsCommands();
            this.addShouldCommands();
            this.addShouldNotCommands();
            this.addFileCommands();
            this.addTechnicalCommands();
        }
    }

    private void addTechnicalCommands() {
        this.commands.put("toString", new ToString());
        this.commands.put("toWebElement", new ToWebElement());
        this.commands.put("getWrappedElement", new GetWrappedElement());
        this.commands.put("screenshot", new TakeScreenshot());
    }

    private void addActionsCommands() {
        this.commands.put("dragAndDropTo", new DragAndDropTo());
        this.commands.put("hover", new Hover());
        this.commands.put("scrollTo", new ScrollTo());
    }

    private void addInfoCommands() {
        this.commands.put("attr", new GetAttribute());
        this.commands.put("data", new GetDataAttribute());
        this.commands.put("exists", new Exists());
        this.commands.put("innerText", new GetInnerText());
        this.commands.put("innerHtml", new GetInnerHtml());
        this.commands.put("has", new Matches());
        this.commands.put("is", new Matches());
        this.commands.put("isDisplayed", new IsDisplayed());
        this.commands.put("isImage", new IsImage());
        this.commands.put("getText", new GetText());
        this.commands.put("name", new GetName());
        this.commands.put("text", new GetText());
        this.commands.put("getValue", new GetValue());
    }

    private void addClickCommands() {
        this.commands.put("click", new Click());
        this.commands.put("contextClick", new ContextClick());
        this.commands.put("doubleClick", new DoubleClick());
        this.commands.put("followLink", new FollowLink());
    }

    private void addModifyCommands() {
        this.commands.put("selectRadio", new SelectRadio());
        this.commands.put("setSelected", new SetSelected());
        this.commands.put("setValue", new SetValue());
        this.commands.put("val", new Val());
        this.commands.put("append", new Append());
    }

    private void addFindCommands() {
        this.commands.put("find", new Find());
        this.commands.put("$", new Find());
        this.commands.put("findAll", new FindAll());
        this.commands.put("$$", new FindAll());
        this.commands.put("closest", new GetClosest());
        this.commands.put("parent", new GetParent());
    }

    private void addKeyboardCommands() {
        this.commands.put("pressEnter", new PressEnter());
        this.commands.put("pressEscape", new PressEscape());
        this.commands.put("pressTab", new PressTab());
    }

    private void addSelectCommands() {
        this.commands.put("getSelectedOption", new GetSelectedOption());
        this.commands.put("getSelectedText", new GetSelectedText());
        this.commands.put("getSelectedValue", new GetSelectedValue());
        this.commands.put("selectOption", new SelectOptionByText());
        this.commands.put("selectOptionByValue", new SelectOptionByValue());
    }

    private void addFileCommands() {
        this.commands.put("download", new DownloadFile());
        this.commands.put("uploadFile", new UploadFile());
        this.commands.put("uploadFromClasspath", new UploadFileFromClasspath());
    }

    private void addShouldNotCommands() {
        this.commands.put("shouldNot", new ShouldNot());
        this.commands.put("shouldNotHave", new ShouldNotHave());
        this.commands.put("shouldNotBe", new ShouldNotBe());
        this.commands.put("waitWhile", new ShouldNotBe());
    }

    private void addShouldCommands() {
        this.commands.put("should", new Should());
        this.commands.put("shouldHave", new ShouldHave());
        this.commands.put("shouldBe", new ShouldBe());
        this.commands.put("waitUntil", new ShouldBe());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String method, Command command) {
        Commands commands = this;
        synchronized (commands) {
            this.commands.put(method, command);
        }
    }

    public <T> T execute(Object proxy, WebElementSource webElementSource, String methodName, Object[] args) throws IOException {
        Command command = this.commands.get(methodName);
        if (command == null) {
            throw new IllegalArgumentException("Unknown Selenide method: " + methodName);
        }
        return command.execute((SelenideElement)proxy, webElementSource, args);
    }
}

