/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.impl.Waiter;
import com.codeborne.selenide.impl.WebElementSource;
import com.codeborne.selenide.proxy.FileDownloadFilter;
import com.codeborne.selenide.proxy.SelenideProxyServer;
import com.google.common.base.Predicate;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.openqa.selenium.WebElement;

public class DownloadFileWithProxyServer {
    private static final Logger log = Logger.getLogger(DownloadFileWithProxyServer.class.getName());
    Waiter waiter = new Waiter();

    public File download(WebElementSource anyClickableElement, WebElement clickable, SelenideProxyServer proxyServer) throws FileNotFoundException {
        return this.clickAndInterceptFileByProxyServer(anyClickableElement, clickable, proxyServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File clickAndInterceptFileByProxyServer(WebElementSource anyClickableElement, WebElement clickable, SelenideProxyServer proxyServer) throws FileNotFoundException {
        String currentWindowHandle = WebDriverRunner.getWebDriver().getWindowHandle();
        Set currentWindows = WebDriverRunner.getWebDriver().getWindowHandles();
        FileDownloadFilter filter = (FileDownloadFilter)proxyServer.responseFilter("download");
        filter.activate();
        try {
            clickable.click();
            this.waiter.wait(filter, new HasDownloads());
            File file = this.firstDownloadedFile(anyClickableElement, filter);
            return file;
        }
        finally {
            filter.deactivate();
            this.closeNewWindows(currentWindowHandle, currentWindows);
        }
    }

    private void closeNewWindows(String currentWindowHandle, Set<String> currentWindows) {
        if (WebDriverRunner.getWebDriver().getWindowHandles().size() != currentWindows.size()) {
            HashSet newWindows = new HashSet(WebDriverRunner.getWebDriver().getWindowHandles());
            newWindows.removeAll(currentWindows);
            log.info("File has been opened in a new window, let's close " + newWindows.size() + " new windows");
            for (String newWindow : newWindows) {
                log.info("  Let's close " + newWindow);
                WebDriverRunner.getWebDriver().switchTo().window(newWindow);
                try {
                    WebDriverRunner.getWebDriver().close();
                }
                catch (Exception e) {
                    log.warning("  Failed to close " + newWindow + ": " + e);
                }
            }
            WebDriverRunner.getWebDriver().switchTo().window(currentWindowHandle);
        }
    }

    private File firstDownloadedFile(WebElementSource anyClickableElement, FileDownloadFilter filter) throws FileNotFoundException {
        List<File> files = filter.getDownloadedFiles();
        if (files.isEmpty()) {
            throw new FileNotFoundException("Failed to download file " + anyClickableElement);
        }
        return files.get(0);
    }

    private static class HasDownloads
    implements Predicate<FileDownloadFilter> {
        private HasDownloads() {
        }

        public boolean apply(FileDownloadFilter filter) {
            return !filter.getDownloadedFiles().isEmpty();
        }
    }
}

