/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.WebDriverProvider;
import com.codeborne.selenide.WebDriverRunner;
import java.awt.Toolkit;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.internal.BuildInfo;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;

public class WebDriverFactory {
    private static final Logger log = Logger.getLogger(WebDriverFactory.class.getName());

    public WebDriver createWebDriver(Proxy proxy) {
        log.config("Configuration.browser=" + Configuration.browser);
        log.config("Configuration.remote=" + Configuration.remote);
        log.config("Configuration.browserSize=" + Configuration.browserSize);
        log.config("Configuration.startMaximized=" + Configuration.startMaximized);
        WebDriver webdriver = Configuration.remote != null ? this.createRemoteDriver(Configuration.remote, Configuration.browser, proxy) : ("chrome".equalsIgnoreCase(Configuration.browser) ? this.createChromeDriver(proxy) : (WebDriverRunner.isFirefox() ? this.createFirefoxDriver(proxy) : (WebDriverRunner.isHtmlUnit() ? this.createHtmlUnitDriver(proxy) : (WebDriverRunner.isIE() ? this.createInternetExplorerDriver(proxy) : (WebDriverRunner.isPhantomjs() ? this.createPhantomJsDriver(proxy) : (WebDriverRunner.isOpera() ? this.createOperaDriver(proxy) : (WebDriverRunner.isSafari() ? this.createSafariDriver(proxy) : this.createInstanceOf(Configuration.browser, proxy))))))));
        webdriver = this.adjustBrowserSize(webdriver);
        if (!WebDriverRunner.isHeadless()) {
            Capabilities capabilities = ((RemoteWebDriver)webdriver).getCapabilities();
            log.info("BrowserName=" + capabilities.getBrowserName() + " Version=" + capabilities.getVersion() + " Platform=" + capabilities.getPlatform());
        }
        log.info("Selenide v. " + Selenide.class.getPackage().getImplementationVersion());
        BuildInfo seleniumInfo = new BuildInfo();
        log.info("Selenium WebDriver v. " + seleniumInfo.getReleaseLabel() + " build time: " + seleniumInfo.getBuildTime());
        return webdriver;
    }

    protected WebDriver createRemoteDriver(String remote, String browser, Proxy proxy) {
        try {
            DesiredCapabilities capabilities = this.createCommonCapabilities(proxy);
            capabilities.setBrowserName(browser);
            return new RemoteWebDriver(new URL(remote), (Capabilities)capabilities);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid 'remote' parameter: " + remote, e);
        }
    }

    protected DesiredCapabilities createCommonCapabilities(Proxy proxy) {
        DesiredCapabilities browserCapabilities = new DesiredCapabilities();
        if (proxy != null) {
            browserCapabilities.setCapability("proxy", (Object)proxy);
        }
        return browserCapabilities;
    }

    protected WebDriver createChromeDriver(Proxy proxy) {
        DesiredCapabilities capabilities = this.createCommonCapabilities(proxy);
        ChromeOptions options = new ChromeOptions();
        options.addArguments(new String[]{"test-type"});
        capabilities.setCapability("chromeOptions", (Object)options);
        return new ChromeDriver((Capabilities)capabilities);
    }

    protected WebDriver createFirefoxDriver(Proxy proxy) {
        DesiredCapabilities capabilities = this.createCommonCapabilities(proxy);
        return new FirefoxDriver((Capabilities)capabilities);
    }

    protected WebDriver createHtmlUnitDriver(Proxy proxy) {
        DesiredCapabilities capabilities = DesiredCapabilities.htmlUnitWithJs();
        capabilities.merge((Capabilities)this.createCommonCapabilities(proxy));
        capabilities.setCapability("The xpath expression '%s' selected an object of type '%s' instead of a WebElement", true);
        capabilities.setCapability("The xpath expression '%s' cannot be evaluated", false);
        if (Configuration.browser.indexOf(58) > -1) {
            String emulatedBrowser = Configuration.browser.replaceFirst("htmlunit:(.*)", "$1");
            capabilities.setVersion(emulatedBrowser);
        }
        return new HtmlUnitDriver((Capabilities)capabilities);
    }

    protected WebDriver createInternetExplorerDriver(Proxy proxy) {
        DesiredCapabilities capabilities = this.createCommonCapabilities(proxy);
        return new InternetExplorerDriver((Capabilities)capabilities);
    }

    protected WebDriver createPhantomJsDriver(Proxy proxy) {
        return this.createInstanceOf("org.openqa.selenium.phantomjs.PhantomJSDriver", proxy);
    }

    protected WebDriver createOperaDriver(Proxy proxy) {
        return this.createInstanceOf("com.opera.core.systems.OperaDriver", proxy);
    }

    protected WebDriver createSafariDriver(Proxy proxy) {
        return this.createInstanceOf("org.openqa.selenium.safari.SafariDriver", proxy);
    }

    protected WebDriver adjustBrowserSize(WebDriver driver) {
        if (Configuration.browserSize != null) {
            log.info("Set browser size to " + Configuration.browserSize);
            String[] dimension = Configuration.browserSize.split("x");
            int width = Integer.parseInt(dimension[0]);
            int height = Integer.parseInt(dimension[1]);
            driver.manage().window().setSize(new Dimension(width, height));
        } else if (Configuration.startMaximized) {
            try {
                if (WebDriverRunner.isChrome()) {
                    this.maximizeChromeBrowser(driver.manage().window());
                } else {
                    driver.manage().window().maximize();
                }
            }
            catch (Exception cannotMaximize) {
                log.warning("Cannot maximize " + Configuration.browser + ": " + cannotMaximize);
            }
        }
        return driver;
    }

    protected void maximizeChromeBrowser(WebDriver.Window window) {
        Dimension screenResolution = this.getScreenSize();
        window.setSize(screenResolution);
        window.setPosition(new Point(0, 0));
    }

    Dimension getScreenSize() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        return new Dimension((int)toolkit.getScreenSize().getWidth(), (int)toolkit.getScreenSize().getHeight());
    }

    protected WebDriver createInstanceOf(String className, Proxy proxy) {
        try {
            Class<?> clazz;
            DesiredCapabilities capabilities = this.createCommonCapabilities(proxy);
            capabilities.setJavascriptEnabled(true);
            capabilities.setCapability("takesScreenshot", true);
            capabilities.setCapability("acceptSslCerts", true);
            capabilities.setCapability("handlesAlerts", true);
            if (WebDriverRunner.isPhantomjs()) {
                capabilities.setCapability("phantomjs.cli.args", (Object)new String[]{"--web-security=no", "--ignore-ssl-errors=yes"});
            }
            if (WebDriverProvider.class.isAssignableFrom(clazz = Class.forName(className))) {
                Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                return ((WebDriverProvider)constructor.newInstance(new Object[0])).createDriver(capabilities);
            }
            Constructor<?> constructor = Class.forName(className).getConstructor(Capabilities.class);
            return (WebDriver)constructor.newInstance(capabilities);
        }
        catch (InvocationTargetException e) {
            throw this.runtime(e.getTargetException());
        }
        catch (Exception invalidClassName) {
            throw new IllegalArgumentException(invalidClassName);
        }
    }

    protected RuntimeException runtime(Throwable exception) {
        return exception instanceof RuntimeException ? (RuntimeException)exception : new RuntimeException(exception);
    }
}

