/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.testng;

import com.codeborne.selenide.logevents.ErrorsCollector;
import com.codeborne.selenide.logevents.SelenideLogger;
import org.testng.ITestResult;
import org.testng.reporters.ExitCodeListener;

public class SoftAsserts
extends ExitCodeListener {
    private final ErrorsCollector errorsCollector = new ErrorsCollector();

    public SoftAsserts() {
        SelenideLogger.addListener(this.errorsCollector);
    }

    public void onTestFailure(ITestResult result) {
        super.onTestFailure(result);
        this.failIfErrors(result);
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
        super.onTestFailedButWithinSuccessPercentage(result);
        this.failIfErrors(result);
    }

    public void onTestSuccess(ITestResult result) {
        super.onTestSuccess(result);
        this.failIfErrors(result);
    }

    public void onConfigurationFailure(ITestResult result) {
        super.onConfigurationFailure(result);
        this.failIfErrors(result);
    }

    private void failIfErrors(ITestResult result) {
        this.errorsCollector.failIfErrors(result.getTestClass().getName() + '.' + result.getName());
    }
}

