/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.commands;

import com.codeborne.selenide.Command;
import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.impl.FileDownloader;
import com.codeborne.selenide.impl.WebElementSource;
import com.codeborne.selenide.proxy.FileDownloadFilter;
import com.codeborne.selenide.proxy.SelenideProxyServer;
import com.google.common.base.Predicate;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.openqa.selenium.WebElement;

public class DownloadFile
implements Command<File> {
    private static final Logger log = Logger.getLogger(DownloadFile.class.getName());
    Waiter waiter = new Waiter();

    @Override
    public File execute(SelenideElement proxy, WebElementSource linkWithHref, Object[] args) throws IOException {
        WebElement link = linkWithHref.findAndAssertElementIsVisible();
        if ("legacy".equals(System.getProperty("selenide.fileDownload"))) {
            return FileDownloader.instance.download(link);
        }
        return this.clickAndInterceptFileByProxyServer(linkWithHref, link, WebDriverRunner.webdriverContainer.getProxyServer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File clickAndInterceptFileByProxyServer(WebElementSource linkWithHref, WebElement link, SelenideProxyServer proxyServer) throws FileNotFoundException {
        String currentWindowHandle = WebDriverRunner.getWebDriver().getWindowHandle();
        Set currentWindows = WebDriverRunner.getWebDriver().getWindowHandles();
        FileDownloadFilter filter = (FileDownloadFilter)proxyServer.responseFilter("download");
        filter.activate();
        try {
            link.click();
            this.waiter.wait(filter, new HasDownloads());
            File file = this.firstDownloadedFile(linkWithHref, filter);
            return file;
        }
        finally {
            filter.deactivate();
            this.closeNewWindows(currentWindowHandle, currentWindows);
        }
    }

    private void closeNewWindows(String currentWindowHandle, Set<String> currentWindows) {
        if (WebDriverRunner.getWebDriver().getWindowHandles().size() != currentWindows.size()) {
            HashSet newWindows = new HashSet(WebDriverRunner.getWebDriver().getWindowHandles());
            newWindows.removeAll(currentWindows);
            log.info("File has been opened in a new window, let's close " + newWindows.size() + " new windows");
            for (String newWindow : newWindows) {
                log.info("  Let's close " + newWindow);
                WebDriverRunner.getWebDriver().switchTo().window(newWindow);
                try {
                    WebDriverRunner.getWebDriver().close();
                }
                catch (Exception e) {
                    log.warning("  Failed to close " + newWindow + ": " + e);
                }
            }
            WebDriverRunner.getWebDriver().switchTo().window(currentWindowHandle);
        }
    }

    private File firstDownloadedFile(WebElementSource linkWithHref, FileDownloadFilter filter) throws FileNotFoundException {
        List<File> files = filter.getDownloadedFiles();
        if (files.isEmpty()) {
            throw new FileNotFoundException("Failed to download file " + linkWithHref);
        }
        return files.get(0);
    }

    private static class HasDownloads
    implements Predicate<FileDownloadFilter> {
        private HasDownloads() {
        }

        public boolean apply(FileDownloadFilter filter) {
            return !filter.getDownloadedFiles().isEmpty();
        }
    }

    static class Waiter {
        Waiter() {
        }

        public <T> void wait(T subject, Predicate<T> condition) {
            this.wait(subject, condition, Configuration.timeout, Configuration.pollingInterval);
        }

        public <T> void wait(T subject, Predicate<T> condition, long timeout, long pollingInterval) {
            long start = System.currentTimeMillis();
            while (!this.isTimeoutExceeded(timeout, start) && !condition.apply(subject)) {
                this.sleep(pollingInterval);
            }
        }

        private boolean isTimeoutExceeded(long timeout, long start) {
            return System.currentTimeMillis() - start > timeout;
        }

        void sleep(long milliseconds) {
            try {
                Thread.sleep(milliseconds);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
    }
}

