/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.ex.ElementNotFound;
import com.codeborne.selenide.ex.ElementShould;
import com.codeborne.selenide.ex.ElementShouldNot;
import com.codeborne.selenide.impl.Cleanup;
import com.codeborne.selenide.impl.ElementFinder;
import java.util.Collections;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

public abstract class WebElementSource {
    public abstract WebElement getWebElement();

    public abstract String getSearchCriteria();

    public SelenideElement find(SelenideElement proxy, Object arg, int index) {
        return ElementFinder.wrap((SearchContext)proxy, WebElementSource.getSelector(arg), index);
    }

    public List<WebElement> findAll() throws IndexOutOfBoundsException {
        return Collections.singletonList(this.getWebElement());
    }

    public ElementNotFound createElementNotFoundError(Condition condition, Throwable lastError) {
        return new ElementNotFound(this.getSearchCriteria(), condition, lastError);
    }

    public static By getSelector(Object arg) {
        return arg instanceof By ? (By)arg : By.cssSelector((String)((String)arg));
    }

    public WebElement checkCondition(String prefix, String message, Condition condition, boolean invert) {
        Condition check = invert ? Condition.not(condition) : condition;
        RuntimeException lastError = null;
        WebElement element = null;
        try {
            element = this.getWebElement();
            if (element != null && check.apply(element)) {
                return element;
            }
        }
        catch (RuntimeException e) {
            lastError = e;
        }
        if (Cleanup.of.isInvalidSelectorError(lastError)) {
            throw Cleanup.of.wrap(lastError);
        }
        if (element == null) {
            if (!check.applyNull()) {
                throw this.createElementNotFoundError(check, lastError);
            }
        } else {
            if (invert) {
                throw new ElementShouldNot(this.getSearchCriteria(), prefix, message, condition, element, lastError);
            }
            throw new ElementShould(this.getSearchCriteria(), prefix, message, condition, element, lastError);
        }
        return null;
    }

    public WebElement findAndAssertElementIsVisible() {
        return this.checkCondition("be ", null, Condition.visible, false);
    }
}

