/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.WebDriverProvider;
import com.codeborne.selenide.WebDriverRunner;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.DesiredCapabilities;

abstract class AbstractDriverFactory {
    private static final Logger log = Logger.getLogger(AbstractDriverFactory.class.getName());

    AbstractDriverFactory() {
    }

    abstract boolean supports();

    abstract WebDriver create(Proxy var1);

    WebDriver createInstanceOf(String className, Proxy proxy) {
        try {
            Class<?> clazz;
            DesiredCapabilities capabilities = this.createCommonCapabilities(proxy);
            capabilities.setJavascriptEnabled(true);
            capabilities.setCapability("takesScreenshot", true);
            capabilities.setCapability("handlesAlerts", true);
            if (WebDriverRunner.isPhantomjs()) {
                capabilities.setCapability("phantomjs.cli.args", (Object)new String[]{"--web-security=no", "--ignore-ssl-errors=yes"});
            }
            if (WebDriverProvider.class.isAssignableFrom(clazz = Class.forName(className))) {
                Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                return ((WebDriverProvider)constructor.newInstance(new Object[0])).createDriver(capabilities);
            }
            Constructor<?> constructor = Class.forName(className).getConstructor(Capabilities.class);
            return (WebDriver)constructor.newInstance(capabilities);
        }
        catch (InvocationTargetException e) {
            throw this.runtime(e.getTargetException());
        }
        catch (Exception invalidClassName) {
            throw new IllegalArgumentException(invalidClassName);
        }
    }

    private RuntimeException runtime(Throwable exception) {
        return exception instanceof RuntimeException ? (RuntimeException)exception : new RuntimeException(exception);
    }

    DesiredCapabilities createCommonCapabilities(Proxy proxy) {
        DesiredCapabilities browserCapabilities = new DesiredCapabilities();
        if (proxy != null) {
            browserCapabilities.setCapability("proxy", (Object)proxy);
        }
        if (Configuration.browserVersion != null && !Configuration.browserVersion.isEmpty()) {
            browserCapabilities.setVersion(Configuration.browserVersion);
        }
        browserCapabilities.setCapability("pageLoadStrategy", Configuration.pageLoadStrategy);
        browserCapabilities.setCapability("acceptSslCerts", true);
        this.transferCapabilitiesFromSystemProperties(browserCapabilities);
        browserCapabilities = this.mergeCapabilitiesFromConfiguration(browserCapabilities);
        return browserCapabilities;
    }

    DesiredCapabilities mergeCapabilitiesFromConfiguration(DesiredCapabilities currentCapabilities) {
        return currentCapabilities.merge((Capabilities)Configuration.browserCapabilities);
    }

    private void transferCapabilitiesFromSystemProperties(DesiredCapabilities currentBrowserCapabilities) {
        String prefix = "capabilities.";
        for (String key : System.getProperties().stringPropertyNames()) {
            if (!key.startsWith(prefix)) continue;
            String capability = key.substring(prefix.length());
            String value = System.getProperties().getProperty(key);
            log.config("Use " + key + "=" + value);
            if (value.equals("true") || value.equals("false")) {
                currentBrowserCapabilities.setCapability(capability, (Object)Boolean.valueOf(value));
                continue;
            }
            if (value.matches("^-?\\d+$")) {
                currentBrowserCapabilities.setCapability(capability, (Object)Integer.parseInt(value));
                continue;
            }
            currentBrowserCapabilities.setCapability(capability, value);
        }
    }
}

