/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.webdriver.AbstractDriverFactory;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.lang3.math.NumberUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;

class ChromeDriverFactory
extends AbstractDriverFactory {
    private static final Logger log = Logger.getLogger(ChromeDriverFactory.class.getName());

    ChromeDriverFactory() {
    }

    @Override
    WebDriver create(Proxy proxy) {
        ChromeOptions options = this.createChromeOptions(proxy);
        return new ChromeDriver(options);
    }

    @Override
    boolean supports() {
        return "chrome".equalsIgnoreCase(Configuration.browser);
    }

    ChromeOptions createChromeOptions(Proxy proxy) {
        ChromeOptions options = new ChromeOptions();
        options.setHeadless(Configuration.headless);
        if (!Configuration.browserBinary.isEmpty()) {
            options.setBinary(Configuration.browserBinary);
        }
        if (Configuration.chromeSwitches != null) {
            options.addArguments(new String[]{Configuration.chromeSwitches});
        }
        options.merge((Capabilities)this.createCommonCapabilities(proxy));
        options = this.transferChromeOptionsFromSystemProperties(options);
        log.config("Chrome options:" + options.toString());
        return options;
    }

    private ChromeOptions transferChromeOptionsFromSystemProperties(ChromeOptions currentChromeOptions) {
        String prefix = "chromeoptions.";
        block8: for (String key : System.getProperties().stringPropertyNames()) {
            if (!key.startsWith(prefix)) continue;
            String capability = key.substring(prefix.length());
            String value = System.getProperties().getProperty(key);
            switch (capability) {
                case "args": {
                    List<String> args = Arrays.asList(value.split(","));
                    currentChromeOptions.addArguments(args);
                    continue block8;
                }
                case "prefs": {
                    Map<String, Object> prefs = this.parsePreferencesFromString(value);
                    currentChromeOptions.setExperimentalOption("prefs", prefs);
                    continue block8;
                }
            }
            log.warning(capability + " is ignored.Only so-called arguments (chromeoptions.args=<values comma separated>) and preferences (chromeoptions.prefs=<comma-separated dictionary of key=value> are supported for the chromeoptions at the moment");
        }
        return currentChromeOptions;
    }

    private Map<String, Object> parsePreferencesFromString(String preferencesString) {
        String[] allPrefs;
        HashMap<String, Object> prefs = new HashMap<String, Object>();
        for (String pref : allPrefs = preferencesString.split(",")) {
            String[] keyValue = pref.split("=");
            if (keyValue.length == 1) {
                log.warning(String.format("Missing '=' sign while parsing <key=value> pairs from %s. Key '%s' is ignored.", preferencesString, keyValue[0]));
                continue;
            }
            if (keyValue.length > 2) {
                log.warning(String.format("More than one '=' sign while parsing <key=value> pairs from %s. Key '%s' is ignored.", preferencesString, keyValue[0]));
                continue;
            }
            Object prefValue = this.convertStringToNearestObjectType(keyValue[1]);
            prefs.put(keyValue[0], prefValue);
        }
        return prefs;
    }

    private Object convertStringToNearestObjectType(String value) {
        switch (value) {
            case "true": {
                return true;
            }
            case "false": {
                return false;
            }
        }
        if (NumberUtils.isParsable((String)value)) {
            return Integer.parseInt(value);
        }
        return value;
    }
}

