/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.webdriver.AbstractDriverFactory;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.remote.DesiredCapabilities;

class EdgeDriverFactory
extends AbstractDriverFactory {
    private static final Logger log = Logger.getLogger(EdgeDriverFactory.class.getName());

    EdgeDriverFactory() {
    }

    @Override
    WebDriver create(Proxy proxy) {
        return this.createEdgeDriver(proxy);
    }

    @Override
    boolean supports() {
        return WebDriverRunner.isEdge();
    }

    private WebDriver createEdgeDriver(Proxy proxy) {
        DesiredCapabilities capabilities = this.createCommonCapabilities(proxy);
        EdgeOptions options = new EdgeOptions();
        options.merge((Capabilities)capabilities);
        if (!Configuration.browserBinary.isEmpty()) {
            log.info("Using browser binary: " + Configuration.browserBinary);
            log.warning("Changing browser binary not supported in Edge, setting will be ignored.");
        }
        return new EdgeDriver(options);
    }
}

