/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.webdriver.AbstractDriverFactory;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;

class FirefoxDriverFactory
extends AbstractDriverFactory {
    private static final Logger log = Logger.getLogger(FirefoxDriverFactory.class.getName());

    FirefoxDriverFactory() {
    }

    @Override
    boolean supports() {
        return WebDriverRunner.isFirefox();
    }

    @Override
    WebDriver create(Proxy proxy) {
        return this.createFirefoxDriver(proxy);
    }

    private WebDriver createFirefoxDriver(Proxy proxy) {
        FirefoxOptions options = this.createFirefoxOptions(proxy);
        return new FirefoxDriver(options);
    }

    FirefoxOptions createFirefoxOptions(Proxy proxy) {
        FirefoxOptions firefoxOptions = new FirefoxOptions();
        firefoxOptions.setHeadless(Configuration.headless);
        if (!Configuration.browserBinary.isEmpty()) {
            log.info("Using browser binary: " + Configuration.browserBinary);
            firefoxOptions.setBinary(Configuration.browserBinary);
        }
        firefoxOptions.addPreference("network.automatic-ntlm-auth.trusted-uris", "http://,https://");
        firefoxOptions.addPreference("network.automatic-ntlm-auth.allow-non-fqdn", true);
        firefoxOptions.addPreference("network.negotiate-auth.delegation-uris", "http://,https://");
        firefoxOptions.addPreference("network.negotiate-auth.trusted-uris", "http://,https://");
        firefoxOptions.addPreference("network.http.phishy-userpass-length", 255);
        firefoxOptions.addPreference("security.csp.enable", false);
        firefoxOptions.merge((Capabilities)this.createCommonCapabilities(proxy));
        firefoxOptions = this.transferFirefoxProfileFromSystemProperties(firefoxOptions);
        return firefoxOptions;
    }

    private FirefoxOptions transferFirefoxProfileFromSystemProperties(FirefoxOptions currentFirefoxOptions) {
        String prefix = "firefoxprofile.";
        FirefoxProfile profile = new FirefoxProfile();
        for (String key : System.getProperties().stringPropertyNames()) {
            if (!key.startsWith(prefix)) continue;
            String capability = key.substring(prefix.length());
            String value = System.getProperties().getProperty(key);
            log.config("Use " + key + "=" + value);
            if (value.equals("true") || value.equals("false")) {
                profile.setPreference(capability, Boolean.valueOf(value).booleanValue());
                continue;
            }
            if (value.matches("^-?\\d+$")) {
                profile.setPreference(capability, Integer.parseInt(value));
                continue;
            }
            profile.setPreference(capability, value);
        }
        return currentFirefoxOptions.setProfile(profile);
    }
}

