/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.impl.WebDriverContainer;
import com.codeborne.selenide.impl.WebDriverThreadLocalContainer;
import com.codeborne.selenide.proxy.SelenideProxyServer;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.events.WebDriverEventListener;

public class WebDriverRunner {
    public static WebDriverContainer webdriverContainer = new WebDriverThreadLocalContainer();
    public static final String CHROME = "chrome";
    @Deprecated
    public static final String IE = "ie";
    public static final String INTERNET_EXPLORER = "internet explorer";
    public static final String EDGE = "edge";
    public static final String FIREFOX = "firefox";
    public static final String LEGACY_FIREFOX = "legacy_firefox";
    public static final String SAFARI = "safari";
    public static final String HTMLUNIT = "htmlunit";
    public static final String PHANTOMJS = "phantomjs";
    public static final String OPERA = "opera";
    public static final String JBROWSER = "jbrowser";

    public static void addListener(WebDriverEventListener listener) {
        webdriverContainer.addListener(listener);
    }

    public static void setWebDriver(WebDriver webDriver) {
        webdriverContainer.setWebDriver(webDriver);
    }

    public static WebDriver getWebDriver() {
        return webdriverContainer.getWebDriver();
    }

    public static void setProxy(Proxy webProxy) {
        webdriverContainer.setProxy(webProxy);
    }

    public static WebDriver getAndCheckWebDriver() {
        return webdriverContainer.getAndCheckWebDriver();
    }

    public static SelenideProxyServer getSelenideProxy() {
        return webdriverContainer.getProxyServer();
    }

    public static void closeWebDriver() {
        webdriverContainer.closeWebDriver();
    }

    public static boolean hasWebDriverStarted() {
        return webdriverContainer.hasWebDriverStarted();
    }

    public static boolean isFirefox() {
        return FIREFOX.equalsIgnoreCase(Configuration.browser);
    }

    public static boolean isLegacyFirefox() {
        return LEGACY_FIREFOX.equalsIgnoreCase(Configuration.browser);
    }

    public static boolean isChrome() {
        return CHROME.equalsIgnoreCase(Configuration.browser);
    }

    public static boolean isIE() {
        return INTERNET_EXPLORER.equalsIgnoreCase(Configuration.browser) || IE.equalsIgnoreCase(Configuration.browser);
    }

    public static boolean isEdge() {
        return EDGE.equalsIgnoreCase(Configuration.browser);
    }

    public static boolean isSafari() {
        return SAFARI.equalsIgnoreCase(Configuration.browser);
    }

    public static boolean isHeadless() {
        return WebDriverRunner.isHtmlUnit() || WebDriverRunner.isPhantomjs() || Configuration.headless;
    }

    public static boolean supportsModalDialogs() {
        return !WebDriverRunner.isHeadless() && !WebDriverRunner.isSafari() || WebDriverRunner.isHtmlUnit();
    }

    public static boolean supportsJavascript() {
        return WebDriverRunner.hasWebDriverStarted() && WebDriverRunner.getWebDriver() instanceof JavascriptExecutor;
    }

    public static boolean isHtmlUnit() {
        return Configuration.browser != null && Configuration.browser.startsWith(HTMLUNIT);
    }

    public static boolean isPhantomjs() {
        return PHANTOMJS.equalsIgnoreCase(Configuration.browser);
    }

    public static boolean isOpera() {
        return OPERA.equalsIgnoreCase(Configuration.browser);
    }

    public static boolean isJBrowser() {
        return JBROWSER.equalsIgnoreCase(Configuration.browser);
    }

    public static void clearBrowserCache() {
        webdriverContainer.clearBrowserCache();
    }

    public static String source() {
        return webdriverContainer.getPageSource();
    }

    public static String url() {
        return webdriverContainer.getCurrentUrl();
    }

    public static String currentFrameUrl() {
        return webdriverContainer.getCurrentFrameUrl();
    }
}

