/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.logevents.LogEvent;
import com.codeborne.selenide.logevents.SelenideLog;
import com.codeborne.selenide.logevents.SelenideLogger;
import java.net.URL;
import java.util.logging.Logger;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;

public class Navigator {
    private static final Logger log = Logger.getLogger(Navigator.class.getName());

    public void open(String relativeOrAbsoluteUrl) {
        this.open(relativeOrAbsoluteUrl, "", "", "");
    }

    public void open(URL url) {
        this.open(url, "", "", "");
    }

    public void open(String relativeOrAbsoluteUrl, String domain, String login, String password) {
        if (this.isAbsoluteUrl(relativeOrAbsoluteUrl)) {
            this.navigateToAbsoluteUrl(relativeOrAbsoluteUrl, domain, login, password);
        } else {
            this.navigateToAbsoluteUrl(this.absoluteUrl(relativeOrAbsoluteUrl), domain, login, password);
        }
    }

    public void open(URL url, String domain, String login, String password) {
        this.navigateToAbsoluteUrl(url.toExternalForm());
    }

    protected String absoluteUrl(String relativeUrl) {
        return Configuration.baseUrl + relativeUrl;
    }

    protected void navigateToAbsoluteUrl(String url) {
        this.navigateToAbsoluteUrl(url, "", "", "");
    }

    protected void navigateToAbsoluteUrl(String url, String domain, String login, String password) {
        if (WebDriverRunner.isIE() && !this.isLocalFile(url)) {
            url = this.makeUniqueUrlToAvoidIECaching(url, System.nanoTime());
        } else {
            if (!domain.isEmpty()) {
                domain = domain + "%5C";
            }
            if (!login.isEmpty()) {
                login = login + ":";
            }
            if (!password.isEmpty()) {
                password = password + "@";
            }
            int idx1 = url.indexOf("://") + 3;
            url = (idx1 < 3 ? "" : url.substring(0, idx1 - 3) + "://") + domain + login + password + (idx1 < 3 ? url : url.substring(idx1));
        }
        SelenideLog log = SelenideLogger.beginStep("open", url);
        try {
            WebDriver webdriver = WebDriverRunner.getAndCheckWebDriver();
            webdriver.navigate().to(url);
            this.collectJavascriptErrors((JavascriptExecutor)webdriver);
            SelenideLogger.commitStep(log, LogEvent.EventStatus.PASS);
        }
        catch (WebDriverException e) {
            SelenideLogger.commitStep(log, e);
            e.addInfo("selenide.url", url);
            e.addInfo("selenide.baseUrl", Configuration.baseUrl);
            throw e;
        }
        catch (RuntimeException e) {
            SelenideLogger.commitStep(log, e);
            throw e;
        }
        catch (Error e) {
            SelenideLogger.commitStep(log, e);
            throw e;
        }
    }

    protected void collectJavascriptErrors(JavascriptExecutor webdriver) {
        if (!Configuration.captureJavascriptErrors) {
            return;
        }
        try {
            webdriver.executeScript("if (!window._selenide_jsErrors) {\n  window._selenide_jsErrors = [];\n}\nif (!window.onerror) {\n  window.onerror = function (errorMessage, url, lineNumber) {\n    var message = errorMessage + ' at ' + url + ':' + lineNumber;\n    window._selenide_jsErrors.push(message);\n    return false;\n  };\n}\n", new Object[0]);
        }
        catch (UnsupportedOperationException cannotExecuteJsAgainstPlainTextPage) {
            log.warning(cannotExecuteJsAgainstPlainTextPage.toString());
        }
        catch (WebDriverException cannotExecuteJs) {
            log.severe(cannotExecuteJs.toString());
        }
    }

    protected String makeUniqueUrlToAvoidIECaching(String url, long unique) {
        if (url.contains("timestamp=")) {
            return url.replaceFirst("(.*)(timestamp=)(.*)([&#].*)", "$1$2" + unique + "$4").replaceFirst("(.*)(timestamp=)(.*)$", "$1$2" + unique);
        }
        return url.contains("?") ? url + "&timestamp=" + unique : url + "?timestamp=" + unique;
    }

    boolean isAbsoluteUrl(String relativeOrAbsoluteUrl) {
        return relativeOrAbsoluteUrl.toLowerCase().startsWith("http:") || relativeOrAbsoluteUrl.toLowerCase().startsWith("https:") || this.isLocalFile(relativeOrAbsoluteUrl);
    }

    protected boolean isLocalFile(String url) {
        return url.toLowerCase().startsWith("file:");
    }

    public void back() {
        WebDriverRunner.getWebDriver().navigate().back();
    }

    public void forward() {
        WebDriverRunner.getWebDriver().navigate().forward();
    }

    public void refresh() {
        WebDriverRunner.getWebDriver().navigate().refresh();
    }
}

