/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.impl.WebElementsCollection;
import java.util.List;
import org.openqa.selenium.WebElement;

public class TailOfCollection
implements WebElementsCollection {
    private final WebElementsCollection originalCollection;
    private final int size;
    private List<WebElement> actualElements;

    public TailOfCollection(WebElementsCollection originalCollection, int size) {
        this.originalCollection = originalCollection;
        this.size = size;
    }

    @Override
    public List<WebElement> getElements() {
        if (this.actualElements == null) {
            return this.getActualElements();
        }
        return this.actualElements;
    }

    @Override
    public List<WebElement> getActualElements() {
        List<WebElement> source = this.originalCollection.getActualElements();
        this.actualElements = source.subList(source.size() - Math.min(source.size(), this.size), source.size());
        return this.actualElements;
    }

    @Override
    public String description() {
        return this.originalCollection.description() + ".last(" + this.size + ')';
    }
}

