/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.webdriver.AbstractDriverFactory;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.ie.InternetExplorerOptions;
import org.openqa.selenium.remote.DesiredCapabilities;

class InternetExplorerDriverFactory
extends AbstractDriverFactory {
    private static final Logger log = Logger.getLogger(InternetExplorerDriverFactory.class.getName());

    InternetExplorerDriverFactory() {
    }

    @Override
    boolean supports() {
        return WebDriverRunner.isIE();
    }

    @Override
    WebDriver create(Proxy proxy) {
        return this.createInternetExplorerDriver(proxy);
    }

    private WebDriver createInternetExplorerDriver(Proxy proxy) {
        DesiredCapabilities capabilities = this.createCommonCapabilities(proxy);
        InternetExplorerOptions options = new InternetExplorerOptions((Capabilities)capabilities);
        if (!Configuration.browserBinary.isEmpty()) {
            log.info("Using browser binary: " + Configuration.browserBinary);
            log.warning("Changing browser binary not supported in InternetExplorer, setting will be ignored.");
        }
        return new InternetExplorerDriver(options);
    }
}

