/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.webdriver.FirefoxDriverFactory;
import java.util.logging.Logger;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;

class LegacyFirefoxDriverFactory
extends FirefoxDriverFactory {
    private static final Logger log = Logger.getLogger(LegacyFirefoxDriverFactory.class.getName());

    LegacyFirefoxDriverFactory() {
    }

    @Override
    boolean supports() {
        return WebDriverRunner.isLegacyFirefox();
    }

    @Override
    WebDriver create(Proxy proxy) {
        String logFilePath = System.getProperty("webdriver.firefox.logfile", "/dev/null");
        System.setProperty("webdriver.firefox.logfile", logFilePath);
        return this.createLegacyFirefoxDriver(proxy);
    }

    private WebDriver createLegacyFirefoxDriver(Proxy proxy) {
        FirefoxOptions firefoxOptions = this.createFirefoxOptions(proxy);
        firefoxOptions.setLegacy(true);
        return new FirefoxDriver(firefoxOptions);
    }
}

