/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.webdriver.AbstractDriverFactory;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.InvalidArgumentException;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.opera.OperaDriver;
import org.openqa.selenium.opera.OperaOptions;

class OperaDriverFactory
extends AbstractDriverFactory {
    private static final Logger log = Logger.getLogger(OperaDriverFactory.class.getName());

    OperaDriverFactory() {
    }

    @Override
    boolean supports() {
        return WebDriverRunner.isOpera();
    }

    @Override
    WebDriver create(Proxy proxy) {
        OperaOptions operaOptions = this.createOperaOptions(proxy);
        return new OperaDriver(operaOptions);
    }

    OperaOptions createOperaOptions(Proxy proxy) {
        OperaOptions operaOptions = new OperaOptions();
        if (Configuration.headless) {
            throw new InvalidArgumentException("headless browser not supported in Opera. Set headless property to false.");
        }
        if (!Configuration.browserBinary.isEmpty()) {
            log.info("Using browser binary: " + Configuration.browserBinary);
            operaOptions.setBinary(Configuration.browserBinary);
        }
        operaOptions.merge((Capabilities)this.createCommonCapabilities(proxy));
        return operaOptions;
    }
}

