/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.webdriver.AbstractDriverFactory;
import java.util.logging.Logger;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;

class SafariDriverFactory
extends AbstractDriverFactory {
    private static final Logger log = Logger.getLogger(SafariDriverFactory.class.getName());

    SafariDriverFactory() {
    }

    @Override
    boolean supports() {
        return WebDriverRunner.isSafari();
    }

    @Override
    WebDriver create(Proxy proxy) {
        return this.createSafariDriver(proxy);
    }

    private WebDriver createSafariDriver(Proxy proxy) {
        if (!Configuration.browserBinary.isEmpty()) {
            log.info("Using browser binary: " + Configuration.browserBinary);
            log.warning("Changing browser binary not supported in Safari, setting will be ignored.");
        }
        return this.createInstanceOf("org.openqa.selenium.safari.SafariDriver", proxy);
    }
}

