/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.conditions.Text;
import com.codeborne.selenide.impl.Describe;
import com.codeborne.selenide.impl.Html;
import com.google.common.base.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebElement;

public abstract class Condition
implements Predicate<WebElement> {
    public static final Condition visible = new Condition("visible"){

        @Override
        public boolean apply(WebElement element) {
            return element.isDisplayed();
        }
    };
    public static final Condition exist;
    @Deprecated
    public static final Condition present;
    public static final Condition hidden;
    public static final Condition appear;
    public static final Condition appears;
    public static final Condition disappears;
    public static final Condition disappear;
    public static final Condition readonly;
    public static final Condition empty;
    public static final Condition focused;
    public static final Condition enabled;
    public static final Condition disabled;
    public static final Condition selected;
    public static final Condition checked;
    protected final String name;
    protected final boolean nullIsAllowed;

    @Deprecated
    public static Condition hasAttribute(String attributeName, String attributeValue) {
        return Condition.attribute(attributeName, attributeValue);
    }

    public static Condition attribute(final String attributeName) {
        return new Condition("attribute"){

            @Override
            public boolean apply(WebElement element) {
                return element.getAttribute(attributeName) != null;
            }

            @Override
            public String toString() {
                return this.name + " " + attributeName;
            }
        };
    }

    public static Condition attribute(final String attributeName, final String expectedAttributeValue) {
        return new Condition("attribute"){

            @Override
            public boolean apply(WebElement element) {
                return expectedAttributeValue.equals(Condition.getAttributeValue(element, attributeName));
            }

            @Override
            public String toString() {
                return this.name + " " + attributeName + '=' + expectedAttributeValue;
            }
        };
    }

    private static String getAttributeValue(WebElement element, String attributeName) {
        String attr = element.getAttribute(attributeName);
        return attr == null ? "" : attr;
    }

    public static Condition value(final String expectedValue) {
        return new Condition("value"){

            @Override
            public boolean apply(WebElement element) {
                return Html.text.contains(Condition.getAttributeValue(element, "value"), expectedValue);
            }

            @Override
            public String toString() {
                return this.name + " '" + expectedValue + "'";
            }
        };
    }

    public static Condition exactValue(String value) {
        return Condition.attribute("value", value);
    }

    @Deprecated
    public static Condition hasValue(String value) {
        return Condition.value(value);
    }

    public static Condition name(String name) {
        return Condition.attribute("name", name);
    }

    public static Condition type(String type) {
        return Condition.attribute("type", type);
    }

    public static Condition id(String id) {
        return Condition.attribute("id", id);
    }

    public static Condition matchesText(String text) {
        return Condition.matchText(text);
    }

    public static Condition matchText(final String regex) {
        return new Condition("match text"){

            @Override
            public boolean apply(WebElement element) {
                return Html.text.matches(element.getText(), regex);
            }

            @Override
            public String toString() {
                return this.name + " '" + regex + '\'';
            }
        };
    }

    @Deprecated
    public static Condition hasText(String text) {
        return Condition.text(text);
    }

    public static Condition text(String text) {
        return new Text(text);
    }

    public static Condition textCaseSensitive(final String text) {
        return new Condition("textCaseSensitive"){

            @Override
            public boolean apply(WebElement element) {
                return Html.text.containsCaseSensitive(element.getText(), text);
            }

            @Override
            public String toString() {
                return this.name + " '" + text + '\'';
            }
        };
    }

    public static Condition exactText(final String text) {
        return new Condition("exact text"){

            @Override
            public boolean apply(WebElement element) {
                return Html.text.equals(element.getText(), text);
            }

            @Override
            public String toString() {
                return this.name + " '" + text + '\'';
            }
        };
    }

    public static Condition exactTextCaseSensitive(final String text) {
        return new Condition("exact text case sensitive"){

            @Override
            public boolean apply(WebElement element) {
                return Html.text.equalsCaseSensitive(element.getText(), text);
            }

            @Override
            public String toString() {
                return this.name + " '" + text + '\'';
            }
        };
    }

    @Deprecated
    public static boolean hasClass(WebElement element, String cssClass) {
        String classes = element.getAttribute("class");
        return classes != null && Condition.contains(classes.split(" "), cssClass);
    }

    private static <T> boolean contains(T[] objects, T object) {
        for (T object1 : objects) {
            if (!object.equals(object1)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static Condition hasClass(String cssClass) {
        return Condition.cssClass(cssClass);
    }

    public static Condition cssClass(final String cssClass) {
        return new Condition("css class"){

            @Override
            public boolean apply(WebElement element) {
                return 11.hasClass(element, cssClass);
            }

            @Override
            public String toString() {
                return this.name + " '" + cssClass + '\'';
            }
        };
    }

    public static Condition cssValue(final String propertyName, final String expectedValue) {
        return new Condition("cssValue"){

            @Override
            public boolean apply(WebElement element) {
                String actualValue = element.getCssValue(propertyName);
                return StringUtils.defaultString((String)expectedValue).equalsIgnoreCase(StringUtils.defaultString((String)actualValue));
            }

            @Override
            public String actualValue(WebElement element) {
                return element.getCssValue(propertyName);
            }

            @Override
            public String toString() {
                return this.name + " " + propertyName + '=' + expectedValue;
            }
        };
    }

    public static Condition not(final Condition condition) {
        return new Condition("not " + condition.name, !condition.nullIsAllowed){

            @Override
            public boolean apply(WebElement element) {
                return !condition.apply(element);
            }

            @Override
            public String actualValue(WebElement element) {
                return condition.actualValue(element);
            }
        };
    }

    public static Condition and(String name, final Condition ... condition) {
        return new Condition(name){
            private Condition lastFailedCondition;

            @Override
            public boolean apply(WebElement element) {
                for (Condition c : condition) {
                    if (c.apply(element)) continue;
                    this.lastFailedCondition = c;
                    return false;
                }
                return true;
            }

            @Override
            public String actualValue(WebElement element) {
                return this.lastFailedCondition == null ? null : this.lastFailedCondition.actualValue(element);
            }

            @Override
            public String toString() {
                return this.lastFailedCondition == null ? super.toString() : this.lastFailedCondition.toString();
            }
        };
    }

    public static Condition or(String name, final Condition ... condition) {
        return new Condition(name){
            private Condition firstFailedCondition;

            @Override
            public boolean apply(WebElement element) {
                for (Condition c : condition) {
                    if (c.apply(element)) {
                        return true;
                    }
                    if (this.firstFailedCondition != null) continue;
                    this.firstFailedCondition = c;
                }
                return false;
            }

            @Override
            public String actualValue(WebElement element) {
                return this.firstFailedCondition == null ? null : this.firstFailedCondition.actualValue(element);
            }

            @Override
            public String toString() {
                return this.firstFailedCondition == null ? super.toString() : this.firstFailedCondition.toString();
            }
        };
    }

    public static Condition be(Condition delegate) {
        return Condition.wrap("be", delegate);
    }

    public static Condition have(Condition delegate) {
        return Condition.wrap("have", delegate);
    }

    private static Condition wrap(final String prefix, final Condition delegate) {
        return new Condition(delegate.name, delegate.applyNull()){

            @Override
            public boolean apply(WebElement element) {
                return delegate.apply(element);
            }

            @Override
            public String actualValue(WebElement element) {
                return delegate.actualValue(element);
            }

            @Override
            public String toString() {
                return prefix + ' ' + delegate.toString();
            }
        };
    }

    public Condition(String name) {
        this(name, false);
    }

    public Condition(String name, boolean absentElementMatchesCondition) {
        this.name = name;
        this.nullIsAllowed = absentElementMatchesCondition;
    }

    public abstract boolean apply(WebElement var1);

    public final boolean applyNull() {
        return this.nullIsAllowed;
    }

    public String actualValue(WebElement element) {
        return null;
    }

    public Condition because(String message) {
        return new ExplainedCondition(this, message);
    }

    public String toString() {
        return this.name;
    }

    static {
        present = exist = new Condition("exist"){

            @Override
            public boolean apply(WebElement element) {
                try {
                    element.isDisplayed();
                    return true;
                }
                catch (StaleElementReferenceException e) {
                    return false;
                }
            }
        };
        hidden = new Condition("hidden", true){

            @Override
            public boolean apply(WebElement element) {
                try {
                    return !element.isDisplayed();
                }
                catch (StaleElementReferenceException elementHasDisappeared) {
                    return true;
                }
            }
        };
        appear = visible;
        appears = visible;
        disappears = hidden;
        disappear = hidden;
        readonly = Condition.attribute("readonly");
        empty = Condition.and("empty", Condition.exactValue(""), Condition.exactText(""));
        focused = new Condition("focused"){

            @Override
            public boolean apply(WebElement webElement) {
                WebElement focusedElement = Selenide.getFocusedElement();
                return focusedElement != null && focusedElement.equals(webElement);
            }

            @Override
            public String actualValue(WebElement webElement) {
                WebElement focusedElement = Selenide.getFocusedElement();
                return focusedElement == null ? "No focused focusedElement found " : "Focused focusedElement: " + Describe.describe(focusedElement) + ", current focusedElement: " + Describe.describe(webElement);
            }
        };
        enabled = new Condition("enabled"){

            @Override
            public boolean apply(WebElement element) {
                return element.isEnabled();
            }

            @Override
            public String actualValue(WebElement element) {
                return element.isEnabled() ? "enabled" : "disabled";
            }
        };
        disabled = new Condition("disabled"){

            @Override
            public boolean apply(WebElement element) {
                return !element.isEnabled();
            }

            @Override
            public String actualValue(WebElement element) {
                return element.isEnabled() ? "enabled" : "disabled";
            }
        };
        selected = new Condition("selected"){

            @Override
            public boolean apply(WebElement element) {
                return element.isSelected();
            }

            @Override
            public String actualValue(WebElement element) {
                return String.valueOf(element.isSelected());
            }
        };
        checked = new Condition("checked"){

            @Override
            public boolean apply(WebElement element) {
                return element.isSelected();
            }

            @Override
            public String actualValue(WebElement element) {
                return String.valueOf(element.isSelected());
            }
        };
    }

    private static class ExplainedCondition
    extends Condition {
        private final Condition delegate;
        private final String message;

        private ExplainedCondition(Condition delegate, String message) {
            super(delegate.name, delegate.nullIsAllowed);
            this.delegate = delegate;
            this.message = message;
        }

        @Override
        public boolean apply(WebElement element) {
            return this.delegate.apply(element);
        }

        @Override
        public String actualValue(WebElement element) {
            return this.delegate.actualValue(element);
        }

        @Override
        public String toString() {
            return this.delegate.toString() + " (because " + this.message + ")";
        }
    }
}

