/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.CollectionCondition;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.ex.UIAssertionError;
import com.codeborne.selenide.impl.Cleanup;
import com.codeborne.selenide.impl.CollectionElement;
import com.codeborne.selenide.impl.CollectionElementByCondition;
import com.codeborne.selenide.impl.FilteringCollection;
import com.codeborne.selenide.impl.HeadOfCollection;
import com.codeborne.selenide.impl.LastCollectionElement;
import com.codeborne.selenide.impl.SelenideElementIterator;
import com.codeborne.selenide.impl.SelenideElementListIterator;
import com.codeborne.selenide.impl.TailOfCollection;
import com.codeborne.selenide.impl.WebElementsCollection;
import com.codeborne.selenide.impl.WebElementsCollectionWrapper;
import com.codeborne.selenide.logevents.ErrorsCollector;
import com.codeborne.selenide.logevents.LogEvent;
import com.codeborne.selenide.logevents.SelenideLog;
import com.codeborne.selenide.logevents.SelenideLogger;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

public class ElementsCollection
extends AbstractList<SelenideElement> {
    private final WebElementsCollection collection;

    public ElementsCollection(WebElementsCollection collection) {
        this.collection = collection;
    }

    public ElementsCollection shouldHaveSize(int expectedSize) {
        return this.shouldHave(CollectionCondition.size(expectedSize));
    }

    public ElementsCollection shouldBe(CollectionCondition ... conditions) {
        return this.should("be", Configuration.collectionsTimeout, conditions);
    }

    public ElementsCollection shouldBe(CollectionCondition condition, long timeoutMs) {
        return this.should("be", timeoutMs, this.toArray(condition));
    }

    public ElementsCollection shouldHave(CollectionCondition ... conditions) {
        return this.should("have", Configuration.collectionsTimeout, conditions);
    }

    public ElementsCollection shouldHave(CollectionCondition condition, long timeoutMs) {
        return this.should("have", timeoutMs, this.toArray(condition));
    }

    private CollectionCondition[] toArray(CollectionCondition condition) {
        return new CollectionCondition[]{condition};
    }

    protected ElementsCollection should(String prefix, long timeoutMs, CollectionCondition ... conditions) {
        ErrorsCollector.validateAssertionMode();
        SelenideLog log = SelenideLogger.beginStep(this.collection.description(), "should " + prefix, conditions);
        try {
            for (CollectionCondition condition : conditions) {
                this.waitUntil(condition, timeoutMs);
            }
            SelenideLogger.commitStep(log, LogEvent.EventStatus.PASS);
            return this;
        }
        catch (Error error) {
            Error wrappedError = UIAssertionError.wrap(error, timeoutMs);
            SelenideLogger.commitStep(log, wrappedError);
            switch (Configuration.assertionMode) {
                case SOFT: {
                    return this;
                }
            }
            throw wrappedError;
        }
        catch (RuntimeException e) {
            SelenideLogger.commitStep(log, e);
            throw e;
        }
    }

    protected void waitUntil(CollectionCondition condition, long timeoutMs) {
        WebDriverException lastError = null;
        List<WebElement> actualElements = null;
        long startTime = System.currentTimeMillis();
        do {
            block4: {
                try {
                    actualElements = this.collection.getElements();
                    if (condition.apply(actualElements)) {
                        return;
                    }
                }
                catch (WebDriverException elementNotFound) {
                    lastError = elementNotFound;
                    if (!Cleanup.of.isInvalidSelectorError(elementNotFound)) break block4;
                    throw Cleanup.of.wrap(elementNotFound);
                }
            }
            this.sleep(Configuration.collectionsPollingInterval);
        } while (System.currentTimeMillis() - startTime < timeoutMs);
        condition.fail(this.collection, actualElements, (Exception)((Object)lastError), timeoutMs);
    }

    void sleep(long ms) {
        Selenide.sleep(ms);
    }

    public ElementsCollection filter(Condition condition) {
        return new ElementsCollection(new FilteringCollection(this.collection, condition));
    }

    public ElementsCollection filterBy(Condition condition) {
        return this.filter(condition);
    }

    public ElementsCollection exclude(Condition condition) {
        return new ElementsCollection(new FilteringCollection(this.collection, Condition.not(condition)));
    }

    public ElementsCollection excludeWith(Condition condition) {
        return this.exclude(condition);
    }

    public SelenideElement find(Condition condition) {
        return CollectionElementByCondition.wrap(this.collection, condition);
    }

    public SelenideElement findBy(Condition condition) {
        return this.find(condition);
    }

    private List<WebElement> getElements() {
        return this.collection.getElements();
    }

    public List<String> texts() {
        return ElementsCollection.texts(this.getElements());
    }

    @Deprecated
    public String[] getTexts() {
        return ElementsCollection.getTexts(this.getElements());
    }

    public static List<String> texts(Collection<WebElement> elements) {
        return elements.stream().map(e -> ElementsCollection.getText(e)).collect(Collectors.toList());
    }

    @Deprecated
    public static String[] getTexts(Collection<WebElement> elements) {
        String[] texts = new String[elements.size()];
        int i = 0;
        for (WebElement element : elements) {
            texts[i++] = ElementsCollection.getText(element);
        }
        return texts;
    }

    private static String getText(WebElement element) {
        try {
            return element.getText();
        }
        catch (WebDriverException elementDisappeared) {
            return elementDisappeared.toString();
        }
    }

    public static String elementsToString(Collection<WebElement> elements) {
        if (elements == null) {
            return "[not loaded yet...]";
        }
        if (elements.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder(256);
        sb.append("[\n\t");
        for (WebElement element : elements) {
            if (sb.length() > 4) {
                sb.append(",\n\t");
            }
            sb.append(Selenide.$(element));
        }
        sb.append("\n]");
        return sb.toString();
    }

    @Override
    public SelenideElement get(int index) {
        return CollectionElement.wrap(this.collection, index);
    }

    public SelenideElement first() {
        return this.get(0);
    }

    public SelenideElement last() {
        return LastCollectionElement.wrap(this.collection);
    }

    public ElementsCollection first(int elements) {
        return new ElementsCollection(new HeadOfCollection(this.collection, elements));
    }

    public ElementsCollection last(int elements) {
        return new ElementsCollection(new TailOfCollection(this.collection, elements));
    }

    @Override
    public int size() {
        return this.getElements().size();
    }

    @Override
    public Iterator<SelenideElement> iterator() {
        return new SelenideElementIterator(this.fetch());
    }

    @Override
    public ListIterator<SelenideElement> listIterator(int index) {
        return new SelenideElementListIterator(this.fetch(), index);
    }

    private WebElementsCollectionWrapper fetch() {
        List<WebElement> fetchedElements = this.collection.getElements();
        return new WebElementsCollectionWrapper(fetchedElements);
    }

    @Override
    public Object[] toArray() {
        List<WebElement> fetchedElements = this.collection.getElements();
        Object[] result = new Object[fetchedElements.size()];
        Iterator<WebElement> it = fetchedElements.iterator();
        for (int i = 0; i < result.length; ++i) {
            result[i] = Selenide.$(it.next());
        }
        return result;
    }

    public ElementsCollection snapshot() {
        return new ElementsCollection(this.fetch());
    }

    @Override
    public String toString() {
        try {
            return ElementsCollection.elementsToString(this.getElements());
        }
        catch (Exception e) {
            return String.format("[%s]", Cleanup.of.webdriverExceptionMessage(e));
        }
    }
}

