/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.webdriver.AbstractDriverFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.LocalFileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;

class RemoteDriverFactory
extends AbstractDriverFactory {
    private static final Logger log = Logger.getLogger(RemoteDriverFactory.class.getName());

    RemoteDriverFactory() {
    }

    @Override
    boolean supports() {
        return Configuration.remote != null;
    }

    @Override
    WebDriver create(Proxy proxy) {
        return this.createRemoteDriver(Configuration.remote, Configuration.browser, proxy);
    }

    private WebDriver createRemoteDriver(String remote, String browser, Proxy proxy) {
        try {
            DesiredCapabilities capabilities = this.getDriverCapabilities(proxy);
            RemoteWebDriver webDriver = new RemoteWebDriver(new URL(remote), (Capabilities)capabilities);
            webDriver.setFileDetector((FileDetector)new LocalFileDetector());
            return webDriver;
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid 'remote' parameter: " + remote, e);
        }
    }

    DesiredCapabilities getDriverCapabilities(Proxy proxy) {
        DesiredCapabilities capabilities = this.createCommonCapabilities(proxy);
        capabilities.setBrowserName(this.getBrowserNameForGrid());
        if (Configuration.headless) {
            capabilities.merge(this.getHeadlessCapabilities());
        }
        if (!Configuration.browserBinary.isEmpty()) {
            capabilities.merge(this.getBrowserBinaryCapabilites());
        }
        return capabilities;
    }

    Capabilities getBrowserBinaryCapabilites() {
        log.info("Using browser binary: " + Configuration.browserBinary);
        if (WebDriverRunner.isChrome()) {
            ChromeOptions options = new ChromeOptions();
            options.setBinary(Configuration.browserBinary);
            return options;
        }
        if (WebDriverRunner.isFirefox()) {
            FirefoxOptions options = new FirefoxOptions();
            options.setBinary(Configuration.browserBinary);
            return options;
        }
        log.warning("Changing browser binary on remote server is only supported for Chrome/Firefox, setting will be ignored.");
        return new DesiredCapabilities();
    }

    Capabilities getHeadlessCapabilities() {
        log.info("Starting in headless mode");
        if (WebDriverRunner.isChrome()) {
            ChromeOptions options = new ChromeOptions();
            options.setHeadless(Configuration.headless);
            return options;
        }
        if (WebDriverRunner.isFirefox()) {
            FirefoxOptions options = new FirefoxOptions();
            options.setHeadless(Configuration.headless);
            return options;
        }
        log.warning("Headless mode on remote server is only supported for Chrome/Firefox, setting will be ignored.");
        return new DesiredCapabilities();
    }

    String getBrowserNameForGrid() {
        if (WebDriverRunner.isLegacyFirefox()) {
            return "firefox";
        }
        if (WebDriverRunner.isIE()) {
            return "internet explorer";
        }
        if (WebDriverRunner.isEdge()) {
            return "MicrosoftEdge";
        }
        if (WebDriverRunner.isOpera()) {
            return "operablink";
        }
        return Configuration.browser;
    }
}

