/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.impl.Describe;
import com.codeborne.selenide.webdriver.AbstractDriverFactory;
import com.codeborne.selenide.webdriver.ChromeDriverFactory;
import com.codeborne.selenide.webdriver.DefaultDriverFactory;
import com.codeborne.selenide.webdriver.EdgeDriverFactory;
import com.codeborne.selenide.webdriver.FirefoxDriverFactory;
import com.codeborne.selenide.webdriver.HtmlUnitDriverFactory;
import com.codeborne.selenide.webdriver.InternetExplorerDriverFactory;
import com.codeborne.selenide.webdriver.JBrowserDriverFactory;
import com.codeborne.selenide.webdriver.LegacyFirefoxDriverFactory;
import com.codeborne.selenide.webdriver.OperaDriverFactory;
import com.codeborne.selenide.webdriver.PhantomJsDriverFactory;
import com.codeborne.selenide.webdriver.RemoteDriverFactory;
import com.codeborne.selenide.webdriver.SafariDriverFactory;
import com.codeborne.selenide.webdriver.WebDriverBinaryManager;
import java.awt.Toolkit;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.openqa.selenium.BuildInfo;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.Point;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;

public class WebDriverFactory {
    private static final Logger log = Logger.getLogger(WebDriverFactory.class.getName());
    protected List<AbstractDriverFactory> factories = Arrays.asList(new RemoteDriverFactory(), new ChromeDriverFactory(), new LegacyFirefoxDriverFactory(), new FirefoxDriverFactory(), new HtmlUnitDriverFactory(), new EdgeDriverFactory(), new InternetExplorerDriverFactory(), new PhantomJsDriverFactory(), new OperaDriverFactory(), new SafariDriverFactory(), new JBrowserDriverFactory());
    protected WebDriverBinaryManager webDriverBinaryManager = new WebDriverBinaryManager();

    public WebDriver createWebDriver(Proxy proxy) {
        log.config("Configuration.browser=" + Configuration.browser);
        log.config("Configuration.browser.version=" + Configuration.browserVersion);
        log.config("Configuration.remote=" + Configuration.remote);
        log.config("Configuration.browserSize=" + Configuration.browserSize);
        log.config("Configuration.startMaximized=" + Configuration.startMaximized);
        if (Configuration.driverManagerEnabled && Configuration.remote == null) {
            this.webDriverBinaryManager.setupBinaryPath();
        }
        WebDriver webdriver = this.factories.stream().filter(AbstractDriverFactory::supports).findAny().map(driverFactory -> driverFactory.create(proxy)).orElseGet(() -> new DefaultDriverFactory().create(proxy));
        webdriver = this.adjustBrowserSize(webdriver);
        webdriver = this.adjustBrowserPosition(webdriver);
        this.logBrowserVersion(webdriver);
        log.info("Selenide v. " + Selenide.class.getPackage().getImplementationVersion());
        this.logSeleniumInfo();
        return webdriver;
    }

    protected WebDriver adjustBrowserPosition(WebDriver driver) {
        if (Configuration.browserPosition != null) {
            log.info("Set browser position to " + Configuration.browserPosition);
            String[] coordinates = Configuration.browserPosition.split("x");
            int x = Integer.parseInt(coordinates[0]);
            int y = Integer.parseInt(coordinates[1]);
            Point target = new Point(x, y);
            Point current = driver.manage().window().getPosition();
            if (!current.equals((Object)target)) {
                driver.manage().window().setPosition(target);
            }
        }
        return driver;
    }

    protected WebDriver adjustBrowserSize(WebDriver driver) {
        if (Configuration.browserSize != null) {
            log.info("Set browser size to " + Configuration.browserSize);
            String[] dimension = Configuration.browserSize.split("x");
            int width = Integer.parseInt(dimension[0]);
            int height = Integer.parseInt(dimension[1]);
            driver.manage().window().setSize(new Dimension(width, height));
        } else if (Configuration.startMaximized) {
            try {
                if (WebDriverRunner.isChrome()) {
                    this.maximizeChromeBrowser(driver.manage().window());
                } else {
                    driver.manage().window().maximize();
                }
            }
            catch (Exception cannotMaximize) {
                log.warning("Cannot maximize " + Describe.describe(driver) + ": " + cannotMaximize);
            }
        }
        return driver;
    }

    protected void maximizeChromeBrowser(WebDriver.Window window) {
        Dimension screenResolution = this.getScreenSize();
        window.setSize(screenResolution);
        window.setPosition(new Point(0, 0));
    }

    Dimension getScreenSize() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        return new Dimension((int)toolkit.getScreenSize().getWidth(), (int)toolkit.getScreenSize().getHeight());
    }

    protected void logSeleniumInfo() {
        if (Configuration.remote == null) {
            BuildInfo seleniumInfo = new BuildInfo();
            log.info("Selenium WebDriver v. " + seleniumInfo.getReleaseLabel() + " build time: " + seleniumInfo.getBuildTime());
        }
    }

    protected void logBrowserVersion(WebDriver webdriver) {
        if (webdriver instanceof HasCapabilities) {
            Capabilities capabilities = ((HasCapabilities)webdriver).getCapabilities();
            log.info("BrowserName=" + capabilities.getBrowserName() + " Version=" + capabilities.getVersion() + " Platform=" + capabilities.getPlatform());
        } else {
            log.info("BrowserName=" + webdriver.getClass().getName());
        }
    }
}

