/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.ex.ElementNotFound;
import com.codeborne.selenide.impl.SelenideElementProxy;
import com.codeborne.selenide.impl.WebElementSource;
import com.codeborne.selenide.impl.WebElementsCollection;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.openqa.selenium.WebElement;

public class CollectionElement
extends WebElementSource {
    private final WebElementsCollection collection;
    private final int index;

    public static SelenideElement wrap(WebElementsCollection collection, int index) {
        return (SelenideElement)Proxy.newProxyInstance(collection.getClass().getClassLoader(), new Class[]{SelenideElement.class}, (InvocationHandler)new SelenideElementProxy(new CollectionElement(collection, index)));
    }

    CollectionElement(WebElementsCollection collection, int index) {
        this.collection = collection;
        this.index = index;
    }

    @Override
    public WebElement getWebElement() {
        return this.collection.getElements().get(this.index);
    }

    @Override
    public String getSearchCriteria() {
        return this.collection.description() + '[' + this.index + ']';
    }

    @Override
    public ElementNotFound createElementNotFoundError(Condition condition, Throwable lastError) {
        if (this.collection.getElements().isEmpty()) {
            return new ElementNotFound(this.collection.description(), Condition.visible, lastError);
        }
        return super.createElementNotFoundError(condition, lastError);
    }

    public String toString() {
        return this.getSearchCriteria();
    }
}

