/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.ex.ElementNotFound;
import com.codeborne.selenide.impl.Describe;
import com.codeborne.selenide.impl.SelenideElementProxy;
import com.codeborne.selenide.impl.WebElementSelector;
import com.codeborne.selenide.impl.WebElementSource;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

public class ElementFinder
extends WebElementSource {
    private final SearchContext parent;
    private final By criteria;
    private final int index;

    public static SelenideElement wrap(WebElement parent, String cssSelector) {
        return ElementFinder.wrap((SearchContext)Selenide.$(parent), By.cssSelector((String)cssSelector), 0);
    }

    public static SelenideElement wrap(String cssSelector, int index) {
        return ElementFinder.wrap(null, By.cssSelector((String)cssSelector), index);
    }

    public static SelenideElement wrap(WebElement parent, String cssSelector, int index) {
        return ElementFinder.wrap((SearchContext)Selenide.$(parent), By.cssSelector((String)cssSelector), index);
    }

    public static SelenideElement wrap(By criteria) {
        return ElementFinder.wrap(null, criteria, 0);
    }

    public static SelenideElement wrap(SearchContext parent, By criteria, int index) {
        return ElementFinder.wrap(SelenideElement.class, parent, criteria, index);
    }

    public static <T extends SelenideElement> T wrap(Class<T> clazz, SearchContext parent, By criteria, int index) {
        return (T)((SelenideElement)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{clazz}, (InvocationHandler)new SelenideElementProxy(new ElementFinder(parent, criteria, index))));
    }

    ElementFinder(SearchContext parent, By criteria, int index) {
        this.parent = parent;
        this.criteria = criteria;
        this.index = index;
    }

    @Override
    public SelenideElement find(SelenideElement proxy, Object arg, int index) {
        return arg instanceof By ? ElementFinder.wrap((SearchContext)proxy, (By)arg, index) : ElementFinder.wrap((SearchContext)proxy, By.cssSelector((String)((String)arg)), index);
    }

    @Override
    public WebElement getWebElement() throws NoSuchElementException, IndexOutOfBoundsException {
        return this.index == 0 ? WebElementSelector.instance.findElement(this.getSearchContext(), this.criteria) : WebElementSelector.instance.findElements(this.getSearchContext(), this.criteria).get(this.index);
    }

    @Override
    public List<WebElement> findAll() throws NoSuchElementException, IndexOutOfBoundsException {
        return this.index == 0 ? WebElementSelector.instance.findElements(this.getSearchContext(), this.criteria) : super.findAll();
    }

    private SearchContext getSearchContext() {
        return this.parent == null ? WebDriverRunner.getWebDriver() : (this.parent instanceof SelenideElement ? ((SelenideElement)this.parent).toWebElement() : this.parent);
    }

    @Override
    public ElementNotFound createElementNotFoundError(Condition condition, Throwable lastError) {
        if (this.parent instanceof SelenideElement) {
            ((SelenideElement)this.parent).should(Condition.exist);
        } else if (this.parent instanceof WebElement) {
            Selenide.$((WebElement)this.parent).should(Condition.exist);
        }
        return super.createElementNotFoundError(condition, lastError);
    }

    @Override
    public String getSearchCriteria() {
        return this.index == 0 ? Describe.selector(this.criteria) : Describe.selector(this.criteria) + '[' + this.index + ']';
    }

    public String toString() {
        return "{" + this.getSearchCriteria() + '}';
    }
}

