/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.WebDriverRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;

public class JavascriptErrorsCollector {
    private static final Logger log = Logger.getLogger(JavascriptErrorsCollector.class.getName());

    void collectJavascriptErrors(WebDriver webdriver) {
        if (webdriver instanceof JavascriptExecutor && Configuration.captureJavascriptErrors) {
            this.collectJavascriptErrors((JavascriptExecutor)webdriver);
        }
    }

    private void collectJavascriptErrors(JavascriptExecutor webdriver) {
        try {
            webdriver.executeScript("if (!window._selenide_jsErrors) {\n  window._selenide_jsErrors = [];\n}\nif (!window.onerror) {\n  window.onerror = function (errorMessage, url, lineNumber) {\n    var message = errorMessage + ' at ' + url + ':' + lineNumber;\n    window._selenide_jsErrors.push(message);\n    return false;\n  };\n}\n", new Object[0]);
        }
        catch (UnsupportedOperationException cannotExecuteJsAgainstPlainTextPage) {
            log.warning(cannotExecuteJsAgainstPlainTextPage.toString());
        }
        catch (WebDriverException cannotExecuteJs) {
            log.severe(cannotExecuteJs.toString());
        }
    }

    public List<String> getJavascriptErrors() {
        if (!Configuration.captureJavascriptErrors) {
            return Collections.emptyList();
        }
        if (!WebDriverRunner.hasWebDriverStarted()) {
            return Collections.emptyList();
        }
        if (!WebDriverRunner.supportsJavascript()) {
            return Collections.emptyList();
        }
        try {
            Object errors = Selenide.executeJavaScript("return window._selenide_jsErrors", new Object[0]);
            if (errors == null) {
                return Collections.emptyList();
            }
            if (errors instanceof List) {
                return JavascriptErrorsCollector.errorsFromList((List)errors);
            }
            if (errors instanceof Map) {
                return JavascriptErrorsCollector.errorsFromMap((Map)errors);
            }
            return Arrays.asList(errors.toString());
        }
        catch (UnsupportedOperationException | WebDriverException cannotExecuteJs) {
            log.warning(cannotExecuteJs.toString());
            return Collections.emptyList();
        }
    }

    private static List<String> errorsFromList(List<Object> errors) {
        if (errors.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(errors.size());
        for (Object error : errors) {
            result.add(error.toString());
        }
        return result;
    }

    private static List<String> errorsFromMap(Map<Object, Object> errors) {
        if (errors.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(errors.size());
        for (Map.Entry<Object, Object> error : errors.entrySet()) {
            result.add(error.getKey() + ": " + error.getValue());
        }
        return result;
    }
}

