/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.ex.ElementNotFound;
import com.codeborne.selenide.impl.SelenideElementProxy;
import com.codeborne.selenide.impl.WebElementSource;
import com.codeborne.selenide.impl.WebElementsCollection;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.List;
import org.openqa.selenium.WebElement;

public class LastCollectionElement
extends WebElementSource {
    private final WebElementsCollection collection;

    public static SelenideElement wrap(WebElementsCollection collection) {
        return (SelenideElement)Proxy.newProxyInstance(collection.getClass().getClassLoader(), new Class[]{SelenideElement.class}, (InvocationHandler)new SelenideElementProxy(new LastCollectionElement(collection)));
    }

    private LastCollectionElement(WebElementsCollection collection) {
        this.collection = collection;
    }

    @Override
    public WebElement getWebElement() {
        return this.lastElementOf(this.collection.getElements());
    }

    private <T> T lastElementOf(List<T> collection) {
        return collection.get(collection.size() - 1);
    }

    @Override
    public String getSearchCriteria() {
        return this.collection.description() + ".last";
    }

    @Override
    public ElementNotFound createElementNotFoundError(Condition condition, Throwable lastError) {
        if (this.collection.getElements().isEmpty()) {
            return new ElementNotFound(this.collection.description(), Condition.visible, lastError);
        }
        return super.createElementNotFoundError(condition, lastError);
    }

    public String toString() {
        return this.getSearchCriteria();
    }
}

