/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.Screenshots;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.ex.DialogTextMismatch;
import java.util.logging.Logger;
import org.openqa.selenium.Alert;

public class Modals {
    private static final Logger log = Logger.getLogger(Modals.class.getName());

    private boolean doDismissModalDialogs() {
        return !WebDriverRunner.supportsModalDialogs() || Configuration.dismissModalDialogs;
    }

    public void mockModalDialogs() {
        if (this.doDismissModalDialogs()) {
            String jsCode = "  window._selenide_modalDialogReturnValue = true;\n  window.alert = function(message) {};\n  window.confirm = function(message) {\n    return window._selenide_modalDialogReturnValue;\n  };";
            try {
                Selenide.executeJavaScript(jsCode, new Object[0]);
            }
            catch (UnsupportedOperationException cannotExecuteJsAgainstPlainTextPage) {
                log.warning(cannotExecuteJsAgainstPlainTextPage.toString());
            }
        }
    }

    public void onConfirmReturn(boolean confirmReturnValue) {
        if (this.doDismissModalDialogs()) {
            Selenide.executeJavaScript("window._selenide_modalDialogReturnValue = " + confirmReturnValue + ';', new Object[0]);
        }
    }

    public String confirm() {
        return this.confirm(null);
    }

    public String confirm(String expectedDialogText) {
        if (!this.doDismissModalDialogs()) {
            Alert alert = Selenide.switchTo().alert();
            String actualDialogText = alert.getText();
            alert.accept();
            Modals.checkDialogText(expectedDialogText, actualDialogText);
            return actualDialogText;
        }
        return null;
    }

    public String prompt() {
        return this.prompt(null, null);
    }

    public String prompt(String inputText) {
        return this.prompt(null, inputText);
    }

    public String prompt(String expectedDialogText, String inputText) {
        if (!this.doDismissModalDialogs()) {
            Alert alert = Selenide.switchTo().alert();
            String actualDialogText = alert.getText();
            if (inputText != null) {
                alert.sendKeys(inputText);
            }
            alert.accept();
            Modals.checkDialogText(expectedDialogText, actualDialogText);
            return actualDialogText;
        }
        return null;
    }

    public String dismiss() {
        return this.dismiss(null);
    }

    public String dismiss(String expectedDialogText) {
        if (!this.doDismissModalDialogs()) {
            Alert alert = Selenide.switchTo().alert();
            String actualDialogText = alert.getText();
            alert.dismiss();
            Modals.checkDialogText(expectedDialogText, actualDialogText);
            return actualDialogText;
        }
        return null;
    }

    private static void checkDialogText(String expectedDialogText, String actualDialogText) {
        if (expectedDialogText != null && !expectedDialogText.equals(actualDialogText)) {
            Screenshots.takeScreenShot(Selenide.class.getName(), Thread.currentThread().getName());
            throw new DialogTextMismatch(actualDialogText, expectedDialogText);
        }
    }
}

