/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.AuthenticationType;
import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.Credentials;
import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.impl.BasicAuthUrl;
import com.codeborne.selenide.impl.JavascriptErrorsCollector;
import com.codeborne.selenide.logevents.LogEvent;
import com.codeborne.selenide.logevents.SelenideLog;
import com.codeborne.selenide.logevents.SelenideLogger;
import com.codeborne.selenide.proxy.AuthenticationFilter;
import com.codeborne.selenide.proxy.SelenideProxyServer;
import java.net.URL;
import java.util.logging.Logger;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;

public class Navigator {
    private static final Logger log = Logger.getLogger(Navigator.class.getName());
    private JavascriptErrorsCollector javascriptErrorsCollector = new JavascriptErrorsCollector();
    private BasicAuthUrl basicAuthUrl = new BasicAuthUrl();

    public void open(String relativeOrAbsoluteUrl) {
        this.navigateTo(relativeOrAbsoluteUrl, AuthenticationType.BASIC, "", "", "");
    }

    public void open(URL url) {
        this.navigateTo(url.toExternalForm(), AuthenticationType.BASIC, "", "", "");
    }

    public void open(String relativeOrAbsoluteUrl, String domain, String login, String password) {
        this.navigateTo(relativeOrAbsoluteUrl, AuthenticationType.BASIC, domain, login, password);
    }

    public void open(URL url, String domain, String login, String password) {
        this.navigateTo(url.toExternalForm(), AuthenticationType.BASIC, domain, login, password);
    }

    public void open(String relativeOrAbsoluteUrl, AuthenticationType authenticationType, Credentials credentials) {
        this.navigateTo(relativeOrAbsoluteUrl, authenticationType, "", credentials.login, credentials.password);
    }

    private AuthenticationFilter basicAuthRequestFilter() {
        SelenideProxyServer selenideProxy = WebDriverRunner.getSelenideProxy();
        return (AuthenticationFilter)selenideProxy.requestFilter("authentication");
    }

    String absoluteUrl(String relativeOrAbsoluteUrl) {
        return this.isAbsoluteUrl(relativeOrAbsoluteUrl) ? relativeOrAbsoluteUrl : Configuration.baseUrl + relativeOrAbsoluteUrl;
    }

    private void navigateTo(String url, AuthenticationType authenticationType, String domain, String login, String password) {
        this.forceProxyIfNeeded();
        url = this.absoluteUrl(url);
        url = this.appendBasicAuthIfNeeded(url, authenticationType, domain, login, password);
        SelenideLog log = SelenideLogger.beginStep("open", url);
        try {
            WebDriver webdriver = WebDriverRunner.getAndCheckWebDriver();
            this.beforeNavigateTo(authenticationType, domain, login, password);
            webdriver.navigate().to(url);
            this.javascriptErrorsCollector.collectJavascriptErrors(webdriver);
            SelenideLogger.commitStep(log, LogEvent.EventStatus.PASS);
        }
        catch (WebDriverException e) {
            SelenideLogger.commitStep(log, e);
            e.addInfo("selenide.url", url);
            e.addInfo("selenide.baseUrl", Configuration.baseUrl);
            throw e;
        }
        catch (Error | RuntimeException e) {
            SelenideLogger.commitStep(log, e);
            throw e;
        }
    }

    private void forceProxyIfNeeded() {
        if (!Configuration.proxyEnabled && Configuration.fileDownload == Configuration.FileDownloadMode.PROXY) {
            log.warning("Configuration.proxyEnabled == false but Configuration.fileDownload == PROXY. We will enable proxy server automatically.");
            Configuration.proxyEnabled = true;
        }
    }

    private void beforeNavigateTo(AuthenticationType authenticationType, String domain, String login, String password) {
        if (Configuration.proxyEnabled) {
            this.beforeNavigateToWithProxy(authenticationType, domain, login, password);
        } else {
            this.beforeNavigateToWithoutProxy(authenticationType, domain, login, password);
        }
    }

    private void beforeNavigateToWithProxy(AuthenticationType authenticationType, String domain, String login, String password) {
        if (this.hasAuthentication(domain, login, password)) {
            this.basicAuthRequestFilter().setAuthentication(authenticationType, new Credentials(login, password));
        } else {
            this.basicAuthRequestFilter().removeAuthentication();
        }
    }

    private void beforeNavigateToWithoutProxy(AuthenticationType authenticationType, String domain, String login, String password) {
        if (this.hasAuthentication(domain, login, password) && authenticationType != AuthenticationType.BASIC) {
            throw new UnsupportedOperationException("Cannot use " + (Object)((Object)authenticationType) + " authentication without proxy server");
        }
    }

    private boolean hasAuthentication(String domain, String login, String password) {
        return !domain.isEmpty() || !login.isEmpty() || !password.isEmpty();
    }

    private String appendBasicAuthIfNeeded(String url, AuthenticationType authType, String domain, String login, String password) {
        return this.passBasicAuthThroughUrl(authType, domain, login, password) ? this.basicAuthUrl.appendBasicAuthToURL(url, domain, login, password) : url;
    }

    private boolean passBasicAuthThroughUrl(AuthenticationType authenticationType, String domain, String login, String password) {
        return this.hasAuthentication(domain, login, password) && !Configuration.proxyEnabled && authenticationType == AuthenticationType.BASIC;
    }

    boolean isAbsoluteUrl(String relativeOrAbsoluteUrl) {
        return relativeOrAbsoluteUrl.toLowerCase().startsWith("http:") || relativeOrAbsoluteUrl.toLowerCase().startsWith("https:") || this.isLocalFile(relativeOrAbsoluteUrl);
    }

    private boolean isLocalFile(String url) {
        return url.toLowerCase().startsWith("file:");
    }

    public void back() {
        WebDriverRunner.getWebDriver().navigate().back();
    }

    public void forward() {
        WebDriverRunner.getWebDriver().navigate().forward();
    }

    public void refresh() {
        WebDriverRunner.getWebDriver().navigate().refresh();
    }
}

