/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.commands.Commands;
import com.codeborne.selenide.ex.InvalidStateException;
import com.codeborne.selenide.ex.UIAssertionError;
import com.codeborne.selenide.impl.Cleanup;
import com.codeborne.selenide.impl.WebElementSource;
import com.codeborne.selenide.logevents.ErrorsCollector;
import com.codeborne.selenide.logevents.LogEvent;
import com.codeborne.selenide.logevents.SelenideLog;
import com.codeborne.selenide.logevents.SelenideLogger;
import java.io.FileNotFoundException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.openqa.selenium.InvalidElementStateException;
import org.openqa.selenium.WebDriverException;

class SelenideElementProxy
implements InvocationHandler {
    private static final Set<String> methodsToSkipLogging = new HashSet<String>(Arrays.asList("toWebElement", "toString", "getSearchCriteria"));
    private static final Set<String> methodsForSoftAssertion = new HashSet<String>(Arrays.asList("should", "shouldBe", "shouldHave", "shouldNot", "shouldNotHave", "shouldNotBe", "waitUntil", "waitWhile"));
    private final WebElementSource webElementSource;

    protected SelenideElementProxy(WebElementSource webElementSource) {
        this.webElementSource = webElementSource;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object ... args) throws Throwable {
        if (methodsToSkipLogging.contains(method.getName())) {
            return Commands.getInstance().execute(proxy, this.webElementSource, method.getName(), args);
        }
        ErrorsCollector.validateAssertionMode();
        long timeoutMs = this.getTimeoutMs(method, args);
        long pollingIntervalMs = this.getPollingIntervalMs(method, args);
        SelenideLog log = SelenideLogger.beginStep(this.webElementSource.getSearchCriteria(), method.getName(), args);
        try {
            Object result = this.dispatchAndRetry(timeoutMs, pollingIntervalMs, proxy, method, args);
            SelenideLogger.commitStep(log, LogEvent.EventStatus.PASS);
            return result;
        }
        catch (Error error) {
            Error wrappedError = UIAssertionError.wrap(error, timeoutMs);
            SelenideLogger.commitStep(log, wrappedError);
            if (Configuration.assertionMode == Configuration.AssertionMode.SOFT && methodsForSoftAssertion.contains(method.getName())) {
                return proxy;
            }
            throw wrappedError;
        }
        catch (RuntimeException error) {
            SelenideLogger.commitStep(log, error);
            throw error;
        }
    }

    protected Object dispatchAndRetry(long timeoutMs, long pollingIntervalMs, Object proxy, Method method, Object[] args) throws Throwable, Error {
        Throwable lastError;
        long startTime = System.currentTimeMillis();
        do {
            try {
                if (SelenideElement.class.isAssignableFrom(method.getDeclaringClass())) {
                    return Commands.getInstance().execute(proxy, this.webElementSource, method.getName(), args);
                }
                return method.invoke((Object)this.webElementSource.getWebElement(), args);
            }
            catch (InvocationTargetException e) {
                lastError = e.getTargetException();
            }
            catch (Throwable e) {
                lastError = e;
            }
            if (Cleanup.of.isInvalidSelectorError(lastError)) {
                throw Cleanup.of.wrap(lastError);
            }
            if (!SelenideElementProxy.shouldRetryAfterError(lastError)) {
                throw lastError;
            }
            Selenide.sleep(pollingIntervalMs);
        } while (System.currentTimeMillis() - startTime <= timeoutMs);
        if (lastError instanceof UIAssertionError) {
            throw lastError;
        }
        if (lastError instanceof InvalidElementStateException) {
            throw new InvalidStateException(lastError);
        }
        if (lastError instanceof WebDriverException) {
            throw this.webElementSource.createElementNotFoundError(Condition.exist, lastError);
        }
        throw lastError;
    }

    static boolean shouldRetryAfterError(Throwable e) {
        if (e instanceof FileNotFoundException) {
            return false;
        }
        if (e instanceof IllegalArgumentException) {
            return false;
        }
        if (e instanceof ReflectiveOperationException) {
            return false;
        }
        return e instanceof Exception || e instanceof AssertionError;
    }

    private long getTimeoutMs(Method method, Object[] args) {
        return this.isWaitCommand(method) ? (args.length == 3 ? (Long)args[args.length - 2] : (Long)args[args.length - 1]) : Configuration.timeout;
    }

    private long getPollingIntervalMs(Method method, Object[] args) {
        return this.isWaitCommand(method) && args.length == 3 ? (Long)args[args.length - 1] : Configuration.pollingInterval;
    }

    private boolean isWaitCommand(Method method) {
        return "waitUntil".equals(method.getName()) || "waitWhile".equals(method.getName());
    }
}

