/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.logging.LogEntry;

public class WebDriverLogs {
    public List<String> getWebDriverLogs(WebDriver webDriver, String logType, Level logLevel) {
        return this.listToString(this.getLogEntries(webDriver, logType, logLevel));
    }

    private List<LogEntry> getLogEntries(WebDriver webDriver, String logType, Level logLevel) {
        try {
            return webDriver.manage().logs().get(logType).filter(logLevel);
        }
        catch (UnsupportedOperationException ignore) {
            return Collections.emptyList();
        }
    }

    private <T> List<String> listToString(List<T> objects) {
        if (objects == null || objects.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(objects.size());
        for (T object : objects) {
            result.add(object.toString());
        }
        return result;
    }
}

