/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import com.codeborne.selenide.WebDriverRunner;
import io.github.bonigarcia.wdm.WebDriverManager;
import org.apache.commons.lang3.StringUtils;

public class WebDriverBinaryManager {
    public void setupBinaryPath() {
        if (WebDriverRunner.isChrome()) {
            this.setupChrome();
        }
        if (WebDriverRunner.isEdge()) {
            this.setupEdge();
        }
        if (WebDriverRunner.isIE()) {
            this.setupIE();
        }
        if (WebDriverRunner.isOpera()) {
            this.setupOpera();
        }
        if (WebDriverRunner.isPhantomjs()) {
            this.setupPhantomjs();
        }
        if (WebDriverRunner.isFirefox()) {
            this.setupFirefox();
        }
    }

    private void setupChrome() {
        if (!this.isSystemPropertySet("webdriver.chrome.driver")) {
            WebDriverManager.chromedriver().setup();
        }
    }

    private void setupEdge() {
        if (!this.isSystemPropertySet("webdriver.edge.driver")) {
            WebDriverManager.edgedriver().setup();
        }
    }

    private void setupIE() {
        if (!this.isSystemPropertySet("webdriver.ie.driver")) {
            WebDriverManager.iedriver().setup();
        }
    }

    private void setupOpera() {
        if (!this.isSystemPropertySet("webdriver.opera.driver")) {
            WebDriverManager.operadriver().setup();
        }
    }

    private void setupPhantomjs() {
        if (!this.isSystemPropertySet("phantomjs.binary.path")) {
            WebDriverManager.phantomjs().setup();
        }
    }

    private void setupFirefox() {
        if (!this.isSystemPropertySet("webdriver.gecko.driver")) {
            WebDriverManager.firefoxdriver().setup();
        }
    }

    private boolean isSystemPropertySet(String key) {
        return StringUtils.isNotBlank((CharSequence)System.getProperty(key, ""));
    }
}

